c
c Copyright 1998-2001, University of Notre Dame.
c Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
c          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
c 
c This file is part of the Notre Dame LAM implementation of MPI.
c 
c You should have received a copy of the License Agreement for the Notre
c Dame LAM implementation of MPI along with the software; see the file
c LICENSE.  If not, contact Office of Research, University of Notre
c Dame, Notre Dame, IN 46556.
c 
c Redistribution and use in source and binary forms, with or without
c modification, are permitted subject to the conditions specified in the
c LICENSE file.
c 
c THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
c IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
c WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
c DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
c INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
c (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
c SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
c HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
c STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
c IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
c POSSIBILITY OF SUCH DAMAGE.
c 
c Additional copyrights may follow.
c 
c
c $Id: fpi.f,v 1.2 2001/01/22 18:03:35 jsquyres Exp $
c
c Portions taken from the MPICH distribution example fpi.f.
c
c Example program to calculate the value of pi by integrating f(x) =
c 4 / (1 + x^2).
c
      program main

      include 'mpif.h'

      double precision  PI25DT
      parameter        (PI25DT = 3.141592653589793238462643d0)

      double precision  mypi, pi, h, sum, x, f, a
      integer num_iters, rank, size, i, rc

c     Function to integrate

      f(a) = 4.d0 / (1.d0 + a * a)

c     Normal MPI startup

      call MPI_INIT(ierr)
      call MPI_COMM_RANK(MPI_COMM_WORLD, rank, ierr)
      call MPI_COMM_SIZE(MPI_COMM_WORLD, size, ierr)
      print *, "Process ", rank, " of ", size, " is alive"

c     Loop until finished

      num_iters = 1000
      do 20 iter = 2, num_iters

c     Calculate the interval size

      h = 1.0d0 / iter
      sum  = 0.0d0

      do 10 i = rank + 1, iter, size
         x = h * (dble(i) - 0.5d0)
         sum = sum + f(x)
 10   continue
      mypi = h * sum

c     Collect all the partial sums

      call MPI_REDUCE(mypi, pi, 1, MPI_DOUBLE_PRECISION, MPI_SUM, 0,
     $     MPI_COMM_WORLD, ierr)

c     Node 0 prints the answer.

      if (rank .eq. 0) then
         write(6, 97) iter, pi, abs(pi - PI25DT)
 97      format(i3, ' points: pi is approximately: ', F18.16,
     +          ' error is: ', F18.16)
      endif
 20   continue

c     All finished

      call MPI_FINALIZE(rc)
      stop
      end




