/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB/RBD
 *
 *	$Id: getnodes.c,v 6.5 1999/07/28 00:32:07 jsquyres Exp $
 * 
 *	Function:	- multiple node route matching
 */

#include <events.h>
#include <net.h>
#include <rreq.h>
#include <typical.h>

#include <unistd.h>

/*
 * external variables
 */
extern int		errno;

/*
 *	getnodes
 *
 *	Function:	- gets matching node IDs from local router
 *	Accepts: 	- node array
 *			- # array elements
 *			- node type
 *			- node type mask
 *	Returns:	- 0 or ERROR
 */
int
getnodes(pnodes, nnodes, nodetype, typemask)

int4			*pnodes;
int4			nnodes;
int4			nodetype;
int4			typemask;

{
	struct rreq	*request;	/* router request */
	struct rreply	*reply;		/* router reply */
	struct nmsg	nhreq;		/* request message */
	struct nmsg	nhreply;	/* reply message */

	LAM_ZERO_ME(nhreq);
	LAM_ZERO_ME(nhreply);
/*
 * Set up the router request.
 */
	request = (struct rreq *) nhreq.nh_data;
	request->rq_src_event = -getpid();
	request->rq_request = RQGETNODES;
	request->rq_pid = getpid();		/* for sa_rtr */
	request->rq_nodetype = nodetype;
	request->rq_typemask = typemask;

	nhreq.nh_dl_event = EVROUTER;
	nhreq.nh_node = LOCAL;
	nhreq.nh_event = EVROUTER;
	nhreq.nh_type = RSMART;
	nhreq.nh_flags = 0;
	nhreq.nh_length = 0;
	nhreq.nh_msg = 0;

	nhreply.nh_event = -getpid();
	nhreply.nh_type = 0;
	nhreply.nh_flags = 0;
	nhreply.nh_length = nnodes * sizeof(int);
	nhreply.nh_msg = (char *) pnodes;

	if (dsfr(&nhreq, &nhreply)) {
		return(ERROR);
	}

	reply = (struct rreply *) nhreply.nh_data;

	if (reply->rr_reply) {
		errno = reply->rr_reply;
		return(ERROR);
	} else {
		return(0);
	}
}

/*
 *	getntype
 *
 *	Returns:	- # of nodes with types satisfying the
 *			  given type in all bits that are set
 *			  in the given mask
 *	Accepts:	- nodetype bitfield value
 *			- nodetype bitfield mask
 */
int4
getntype(node_type, type_mask)

int4 			node_type;
int4			type_mask;

{
	struct rreq	*request;	/* router request */
	struct rreply	*reply;		/* router reply */
	struct nmsg	nhreq;		/* request message */
	struct nmsg	nhreply;	/* reply message */
/*
 * Set up the router request.
 */
	request = (struct rreq *) nhreq.nh_data;
	request->rq_src_event = -getpid();
	request->rq_request = RQGETNTYPE;
	request->rq_nodetype = node_type;
	request->rq_typemask = type_mask;

	nhreq.nh_dl_event = EVROUTER;
	nhreq.nh_node = LOCAL;
	nhreq.nh_event = EVROUTER;
	nhreq.nh_type = RSMART;
	nhreq.nh_flags = 0;
	nhreq.nh_length = 0;
	nhreq.nh_msg = 0;

	nhreply.nh_event = -getpid();
	nhreply.nh_type = 0;
	nhreply.nh_flags = 0;
	nhreply.nh_length = 0;
	nhreply.nh_msg = 0;

	if (dsfr(&nhreq, &nhreply)) {
		return(ERROR);
	}

	reply = (struct rreply *) nhreply.nh_data;

	if (reply->rr_reply) {
		errno = reply->rr_reply;
		return(ERROR);
	} else {
		return(reply->rr_ntype);
	}
}
