/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: wdelattr.c,v 1.0 1999/07/21 19:00:20 jsquyres Exp $
 *
 *	Function:	- delete attribute
 *			- detach attribute from window
 *	Accepts:	- window
 *			- attribute key
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <errno.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


int
MPI_Win_delete_attr(win, key)

MPI_Win			win;
int			key;

{
	struct _attrkey	*p;
	struct _attr	*pk;
	int		err;

	lam_initerr_m();
	lam_setfunc_m(BLKMPIWINDELETEATTR);
/*
 * Check the arguments.
 */
	if (win == MPI_WIN_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIWINDELETEATTR, lam_mkerr(MPI_ERR_WIN, 0)));
	}

	p = lam_getattr(key);
	if (p == 0) {
		return(lam_errfunc(win->w_comm,
			BLKMPIWINDELETEATTR, lam_mkerr(MPI_ERR_KEYVAL, 0)));
	}
/*
 * Check if the key is attached to the window.
 */
	pk = lam_getkey(win->w_keys, key);
	if (pk == 0) {
		return(lam_errfunc(win->w_comm,
			BLKMPIWINDELETEATTR, lam_mkerr(MPI_ERR_KEYVAL, 0)));
	}
/*
 * Delete the attribute via the callback function.
 */
	if (((MPI_Win_delete_attr_function *) (p->ak_del))
			!= MPI_WIN_NULL_DELETE_FN) {

		if (p->ak_flags & LAM_LANGF77) {
			(*((MPI_F_delete_function *)(p->ak_del)))
				(&win->w_f77handle, &key,
				(int *) &(pk->a_value),
				(int *) &(p->ak_extra), &err);
		} else {
			err = (*((MPI_Win_delete_attr_function *) (p->ak_del)))
				(win, key, pk->a_value, p->ak_extra);
		}

		if (err != MPI_SUCCESS) {
			return(lam_err_win(win, err, 0, "deleting attribute"));
		}
	}
/*
 * Detach the key from the window.
 */
	if (lam_delkey(win->w_keys, key)) {
		return(lam_err_win(win, MPI_ERR_INTERN, errno, "deleting key"));
	}

	lam_resetfunc_m(BLKMPIWINDELETEATTR);
	return(MPI_SUCCESS);
}
