/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	JGH
 *
 *	$Id: tgetattr.c,v 1.1 1999/10/24 00:37:16 jsquyres Exp $
 *
 *	Function:	- get datatype attribute value
 *	Accepts:	- datatype
 *			- attribute key
 *			- attribute value (out)
 *			- found flag (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


int
MPI_Type_get_attr(type, key, value, found)

MPI_Datatype		type;
int			key;
void			*value;
int			*found;

{
	struct _attrkey	*pk;
	struct _attr	*p;

	lam_initerr_m();
	lam_setfunc_m(BLKMPITGETATTR);
/*
 * Check the arguments.
 */
	if (type == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITGETATTR, lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	if ((value == 0) || (found == 0)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITGETATTR, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	pk = lam_getattr(key);
	if (pk == 0 || !(pk->ak_flags & LAM_AKTYPE)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITGETATTR, lam_mkerr(MPI_ERR_KEYVAL, 0)));
	}
/*
 * Check if the key is attached to the datatype
 */
	p = lam_getkey(type->dt_keys, key);
	if (p == 0) {
		*found = 0;
	} else {
		*found = 1;
/*
 * This stuff is very confusing.  Be sure to see MPI-2 4.12.7.
 */
		*((void **) value) = (pk->ak_flags & LAM_LANGF77)
			? (void *) &p->a_value : p->a_value;
	}

	lam_resetfunc_m(BLKMPITGETATTR);
	return(MPI_SUCCESS);
}
