/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: testany.c,v 6.3 1999/05/25 22:08:20 kmeyer1 Exp $
 *
 *	Function:	- check if one request completed
 *	Accepts:	- # of requests
 *			- array of requests
 *			- index (out)
 *			- flag (out)
 *			- status (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <mpitrace.h>
#include <rpisys.h>


int

MPI_Testany(count, reqs, index, flag, stat)

int			count;
MPI_Request		*reqs;
int			*index;
int			*flag;
MPI_Status		*stat;

{
	int		i;			/* favourite index */
	int		fl_done;		/* request done flag */
	int		err;			/* error code */
	int		fl_trace;		/* do tracing? */
	MPI_Comm	comm = 0;		/* communicator */
	
	lam_initerr_m();
	lam_setfunc_m(BLKMPITESTANY);

	if (count < 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITESTANY,
				lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	if ((count > 0) && (reqs == 0)) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITESTANY,
				lam_mkerr(MPI_ERR_REQUEST, 0)));
	}

	if ((flag == 0) || (index == 0)) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITESTANY,
				lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Generate a start wrapper trace.
 */
	fl_trace = ((_kio.ki_rtf & RTF_TRON) == RTF_TRON);

	if (fl_trace) {
		lam_tr_wrapstart(BLKMPITESTANY);
	}
/*
 * Loop testing all requests.
 * Skip inactive requests.
 */
	if (stat != MPI_STATUS_IGNORE) {
		lam_emptystat(stat);
	}

	*flag = 1;
	*index = MPI_UNDEFINED;
	err = MPI_SUCCESS;

	for (i = 0; i < count; ++i, ++reqs) {

		if ((*reqs == MPI_REQUEST_NULL) ||
			((*reqs)->rq_state == LAM_RQSINIT)) continue;

		*flag = 0;
		comm = (*reqs)->rq_comm;

		err = MPI_Test(reqs, &fl_done, stat);
		if (err != MPI_SUCCESS) break;

		if (fl_done) {
			*flag = 1;
			*index = i;
			break;
		}
	}
/*
 * Generate an end wrapper trace.
 */
	if (fl_trace) {
		lam_tr_wrapend(BLKMPITESTANY);
	}

	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPITESTANY, err));
	}

	lam_resetfunc_m(BLKMPITESTANY);
	return(MPI_SUCCESS);
}
