/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: shm.usysv.c,v 1.1 1999/07/28 00:32:04 jsquyres Exp $
 *
 *	Function:	- usysv transport low-level routines
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/uio.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>
#include <terror.h>
#include <typical.h>
#include <t_types.h>

/*
 * global functions
 */
int			_shm_cleanup();

/*
 * external functions
 */
extern void		lam_deregister_object();

/*
 * lock control
 */
#define READPOLLCOUNT	10000			/* # loops before usleep() */
#define WRITEPOLLCOUNT	10			/* # loops before usleep() */

/*
 * # loops before usleep()
 */
int			_lock_poll_read = READPOLLCOUNT;	
int			_lock_poll_write = WRITEPOLLCOUNT;	

/*
 * private variables
 */
static struct sembuf	exit_lock = { 0, -1, 0 };
static struct sembuf	exit_unlock = { 0, 1, 0 };
static struct sembuf	exit_op = { 1, -1, IPC_NOWAIT };

#if LAM_HAVE_UNION_SEMUN
static union semun	semctl_arg;
#else
static union {
	int		val;
	struct semid_ds	*buf;
	unsigned short	*array;
} semctl_arg;
#endif


/*
 *	_shm_cleanup
 *
 *	Function:	- clean up a process's shared memory structures
 *	Accepts:	- process
 *	Returns:	- 0 or LAMERROR
 */
int
_shm_cleanup(ps)

struct c2c_proc		*ps;

{
	char		obj[32];
	int		val;			/* cleanup counter */

	if (semop(ps->cp_sem, &exit_lock, 1) < 0) return(LAMERROR);
	if (semop(ps->cp_sem, &exit_op, 1) < 0) return(LAMERROR);

	semctl_arg.val = 0;
	val = semctl(ps->cp_sem, 1, GETVAL, semctl_arg);
	if (val < 0) return(LAMERROR);

	shmdt(_shm_membase);

	if (semop(ps->cp_sem, &exit_unlock, 1) < 0) return(LAMERROR);

	if (val == 0) {
/*
 * The other side of the shared area has already cleaned up so
 * we can delete the semaphores and deregister the shared structures.
 */
		semctl(ps->cp_sem, 0, IPC_RMID, semctl_arg);
		shmctl(ps->cp_shm, IPC_RMID, (struct shmid_ds *) 0);

		sprintf(obj, "%d", ps->cp_sem);
		lam_deregister_object('s', obj);
		sprintf(obj, "%d", ps->cp_shm);
		lam_deregister_object('m', obj);
	}

	return(0);
}
