/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: gfree.c,v 6.4 1999/09/02 01:32:53 jsquyres Exp $
 *
 *	Function:	- free a group
 *	Accepts:	- group (in-out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <MPISYSF.h>
#include <rpisys.h>

int
MPI_Group_free(grp)

MPI_Group		*grp;

{
	struct _proc	**p;
	int		i;
	
	lam_initerr_m();
	lam_setfunc_m(BLKMPIGROUPFREE);

	if (grp == 0 || *grp == MPI_GROUP_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPFREE, lam_mkerr(MPI_ERR_GROUP, 0)));
	} else {
		if ((--(*grp)->g_refcount) == 0) {
/*
 * We don't check for the empty group before since a user may
 * legitimately free a copy of it.  The problem is now that we won't
 * catch an explicit free of MPI_GROUP_EMPTY when copies of it exist.
 */
			if (*grp == MPI_GROUP_EMPTY) {
				(*grp)->g_refcount++;
				return(lam_errfunc(MPI_COMM_WORLD,
					BLKMPIGROUPFREE,
					lam_mkerr(MPI_ERR_GROUP, 0)));
			}

			for (i = (*grp)->g_nprocs, p = (*grp)->g_procs; i > 0;
			     i--, p++) {

				if ((--(*p)->p_refcount) == 0) {
					lam_procfree(*p);
				}
			}

			if ((*grp)->g_f77handle >= 0) {
				lam_F_free_hdl((*grp)->g_f77handle);
			}

			free((char *) *grp);
		}

		*grp = MPI_GROUP_NULL;
	}

	lam_resetfunc_m(BLKMPIGROUPFREE);
	return(MPI_SUCCESS);
}
