/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: gcmp.c,v 6.3 1999/05/25 22:07:53 kmeyer1 Exp $
 *
 *	Function:	- compare two groups
 *	Accepts:	- first group
 *			- second group
 *			- ptr comparison result
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>
#include <string.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*
 * local functions
 */
static int		proccmp();

int
MPI_Group_compare(g1, g2, pres)

MPI_Group		g1;
MPI_Group		g2;
int			*pres;

{
	int		i;			/* favourite index */
	struct _proc	**p1, **p2;		/* favourite pointers */
	struct _proc	**sort1;		/* group1 sort array */
	struct _proc	**sort2;		/* group2 sort array */

	lam_initerr();
	lam_setfunc(BLKMPIGROUPCMP);
/*
 * Check the arguments.
 */
	if ((g1 == MPI_GROUP_NULL) || (g2 == MPI_GROUP_NULL)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPCMP, lam_mkerr(MPI_ERR_GROUP, 0)));
	}

	if (pres == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPCMP, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Handle the trivial cases.
 */
	if (g1 == g2) {
		*pres = MPI_IDENT;
		lam_resetfunc(BLKMPIGROUPCMP);
		return(MPI_SUCCESS);
	}

	if (g1->g_nprocs != g2->g_nprocs) {
		*pres = MPI_UNEQUAL;
		lam_resetfunc(BLKMPIGROUPCMP);
		return(MPI_SUCCESS);
	}
/*
 * Loop checking if same processes in same order.
 */
	p1 = g1->g_procs;
	p2 = g2->g_procs;

	for (i = 0; i < g1->g_nprocs; ++i, ++p1, ++p2) {
		if (*p1 != *p2) break;
	}

	if (i == g1->g_nprocs) {
		*pres = MPI_IDENT;
		lam_resetfunc(BLKMPIGROUPCMP);
		return(MPI_SUCCESS);
	}
/*
 * Loop checking if same processes in different order.
 * Sort the processes and compare the sorted lists for equality.
 */
	i = g1->g_nprocs * sizeof(struct _proc *);
	sort1 = (struct _proc **) malloc((unsigned) (i + i));

	if (sort1 == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIGROUPCMP,
				lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	sort2 = sort1 + g1->g_nprocs;

	memcpy((char *) sort1, (char *) g1->g_procs, i);
	memcpy((char *) sort2, (char *) g2->g_procs, i);

	qsort((char *) sort1, g1->g_nprocs, sizeof(struct _proc *), proccmp);
	qsort((char *) sort2, g2->g_nprocs, sizeof(struct _proc *), proccmp);

	p1 = sort1;
	p2 = sort2;

	for (i = 0; i < g1->g_nprocs; ++i, ++p1, ++p2) {
		if (*p1 != *p2) break;
	}

	*pres = (i == g1->g_nprocs) ? MPI_SIMILAR : MPI_UNEQUAL;

	free((char *) sort1);

	lam_resetfunc(BLKMPIGROUPCMP);
	return(MPI_SUCCESS);
}

/*
 *	proccmp
 *
 *	Function:	- compare 2 process entries
 *	Accepts:	- ptr 2 process pointers
 *	Returns:	- -ve/0/+ve
 */
static int
proccmp(p1, p2)

struct _proc		**p1, **p2;

{
	return(lam_proccmp(*p1, *p2));
}
