/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: ccreatekey.c,v 1.0 1999/07/21 19:00:09 jsquyres Exp $
 *
 *	Function:	- create a communicator attribute key
 *	Accepts:	- copy function
 *			- delete function
 *			- key (out)
 *			- extra state info
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


int
MPI_Comm_create_keyval(cpyfunc, delfunc, key, extra)

MPI_Comm_copy_attr_function	*cpyfunc;
MPI_Comm_delete_attr_function	*delfunc;
int				*key;
void				*extra;

{
        int 		err;

	lam_initerr_m();
	lam_setfunc_m(BLKMPICOMMCREATEKEYVAL);

	err = lam_keyval_create((void_fn *) cpyfunc, (void_fn *) delfunc, 
				key, extra, LAM_AKCOMM);

	if (err != MPI_SUCCESS) {
	    return(lam_errfunc(MPI_COMM_WORLD, BLKMPICOMMCREATEKEYVAL, err));
	}

	lam_resetfunc_m(BLKMPICOMMCREATEKEYVAL);
	return(MPI_SUCCESS);
}
