/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: microsleep.c,v 6.3 1999/07/28 00:31:53 jsquyres Exp $
 * 
 *	Function:	- higher precision sleep (microseconds)
 *			- uses select() timeout value
 *			- does not restart if interrupted
 */

#include <lam_config.h>

#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>

#if LAM_NEED_SYS_SELECT_H
#include <sys/select.h>
#endif

int
microsleep(usec)

unsigned int		usec;

{
	struct timeval	timeout;

	timeout.tv_sec = usec / 1000000;
	timeout.tv_usec = usec % 1000000;

	while ((select(0, (fd_set *) 0, (fd_set *) 0,
			(fd_set *) 0, &timeout) < 0) && (errno == EINTR));

	return(0);
}
