/***************************************************************************
 *
 *  $Id: kzensearchwidget.cpp,v 1.6 2005/05/31 06:54:03 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <iostream>

#include <kcombobox.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <klocale.h>

#include <qradiobutton.h>
#include <qvgroupbox.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qhbuttongroup.h>

#include "kzensearch.h"
#include "kzensearchcondition.h"
#include "kzensearchline.h"
#include "kzensearchwidget.h"

KZenSearchWidget::KZenSearchWidget(QWidget *parent,const char *name)
  :QVBox(parent, name)
{
  fSearch = 0;

  fLines.setAutoDelete(true);

  QVGroupBox * criteriaGroupBox = new QVGroupBox("Search Criteria",this);

  QHButtonGroup * group = new QHButtonGroup(criteriaGroupBox);
  fMatchAllButton = new QRadioButton(i18n("Match all of the following"), group);
  fMatchAnyButton = new QRadioButton(i18n("Match any of the following"), group);
  fMatchAllButton->setChecked(true);
  connect(group, SIGNAL(clicked(int)), this, SLOT(modeChanged(int)));

  fConditions = new QVBox(criteriaGroupBox);
  
  QWidget *buttons = new QWidget(criteriaGroupBox);
  QBoxLayout *l = new QHBoxLayout(buttons, 0, 5);
  l->addStretch(1);
  
  fMoreButton = new KPushButton(i18n("More"), buttons);
  connect(fMoreButton, SIGNAL(clicked()), SLOT(more()));
  l->addWidget(fMoreButton);
  
  fFewerButton = new KPushButton(i18n("Fewer"), buttons);
  connect(fFewerButton, SIGNAL(clicked()), SLOT(fewer()));
  l->addWidget(fFewerButton);
}

KZenSearchWidget::~KZenSearchWidget()
{
  
}

void KZenSearchWidget::modeChanged(int id)
{ 
  if (id==0) {
    fSearch->setSearchMode(KZenSearch::ModeAND);
  } else if (id==1) {
    fSearch->setSearchMode(KZenSearch::ModeOR);
  } else {
    fSearch->setSearchMode(KZenSearch::ModeUnknown);
  }
}

void KZenSearchWidget::more()
{
  KZenSearchLine * line = new KZenSearchLine(fConditions);
  fLines.append(line);
  line->adjustSize();
  line->show();

  fMoreButton->setEnabled(fLines.count() < 8);
  fFewerButton->setEnabled(fLines.count() > 1);

  adjustSize();
  parentWidget()->adjustSize();
  parentWidget()->parentWidget()->adjustSize();

  KZenSearchCondition * con = new KZenSearchCondition();
  fSearch->getConditions().append(con);
  line->setCondition(con);
}

void KZenSearchWidget::fewer()
{
  KZenSearchLine * line = fLines.last();
  fLines.remove(line);

  fMoreButton->setEnabled(fLines.count() < 8);
  fFewerButton->setEnabled(fLines.count() > 1);

  adjustSize();
  parentWidget()->adjustSize();
  parentWidget()->parentWidget()->adjustSize();

  KZenSearchCondition * con = fSearch->getConditions().last();
  fSearch->getConditions().remove(con);
}

void KZenSearchWidget::setSearch(KZenSearch * search)
{
  fSearch = search;

  switch (fSearch->getSearchMode()) {
  case KZenSearch::ModeAND:
    fMatchAllButton->setChecked(true);
    break;
  case KZenSearch::ModeOR:
    fMatchAnyButton->setChecked(true);
    break;
  default:
    fMatchAllButton->setChecked(true);
  }

  fLines.clear();
  if (fSearch->getConditions().count()==0) {
    more();
    return;
  }

  KZenSearchCondition * con;
  KZenSearchLine * line;
  for (uint i=0;i<fSearch->getConditions().count();i++) {
    con = fSearch->getConditions().at(i);
    line = fLines.at(i);
    if (!line) {
      line = new KZenSearchLine(fConditions);
      fLines.append(line);
      line->adjustSize();
      line->show();

      fMoreButton->setEnabled(fLines.count() < 8);
      fFewerButton->setEnabled(fLines.count() > 1);
      adjustSize();
    }
    line->setCondition(con);
  }
}

#include "kzensearchwidget.moc"
