/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef IMPORTIMAGEDLG_H
#define IMPORTIMAGEDLG_H

#include <importimage.h>
#include <qcombobox.h>
#include <knuminput.h>
#include <Magick++.h>

class QPixmap;
class QTimerEvent;
class AlphaSelect;

class ImportImageDlg : public ImportImage
{
  Q_OBJECT
public:
/** Constructor
    @param fname filename of the image file
    @param parent parent QWidget for this dialog
    @param name internal name of the dialog
    @param modal true if the dialog is modal
  */
  ImportImageDlg(const Magick::Image&, QWidget *parent=0, const char *name=0, bool modal=true);
/** Destructor
  */
  ~ImportImageDlg();

/** Get a pointer to the modified Image
    @return pointer to an @ref Image Image structure
  */
  Magick::Image modifiedImage() { return m_image; }
  bool ignoreColor() const { return m_ignoreColor; }
  Magick::Color ignoreColorValue() const { return m_ignoreColorValue; }
  QString flossScheme() const { return Import_FlossScheme->currentText(); }
  double clothCount() const { return Import_ClothCount->value(); }
  bool useFractionals() const { return m_useFractionals; }

public slots:
/** resets the image to the original as loaded state, called in response to the Reset button */
  void resetImage();
/** changes the floss scheme to be applied to the imported image
  * @param index the index in the list of the schemes to be applied
  */
  void schemeChanged(int index);
/** changes the maximum number of colors allowed in the final pattern, called when the MaxColors value changes
  * @param n the maximum number of colors
  */
  void maxColorsChanged(int n);
/** changes the cloth count value, called when the ClothCount value changes, updates the finished size values
  * @param n the cloth count to be used
  */
  void clothCountChanged(double n);
/** changes the scale of the final image relative to the original, called when the scale value changes,
  * updates the finished size values
  * @param s the scale to be applied
  */
  void scaleChanged(int s);
/** use fractional stitches
  * @param s state of checkbox
  */
  void useFractionalsChanged(int s);

protected slots:
  virtual void accept();
  void contextHelp();
  void pickColor();
  void selectColor(QPoint p);

protected:
  virtual void timerEvent(QTimerEvent *);

private:
/** calculates the size of the image when dialog properties are applied to the original image
  */
  void calcSizes();
/** render a pixmap to look like the finished pattern image, used for the image preview
  */
  void renderPixmap();
/** create an image map to be used with the map function
  */
  void createImageMap();

  QPixmap*      m_pixmap;
  QSize         m_originalSize;
  QSize         m_preferredSize;
  bool          m_useFractionals;
  bool          m_ignoreColor;
  AlphaSelect*  m_alphaSelect;
  Magick::Color m_ignoreColorValue;
  Magick::Image m_orig;
  Magick::Image m_image;
  Magick::Image m_map;
};

#endif
