/***************************************************************************
                          xmlprocinstrdlg.cpp  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "xmlprocinstrdlg.h"

#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlabel.h>

XmlProcInstrDlg::XmlProcInstrDlg(QWidget *parent, const char *name, bool bModal, bool bHideComboBoxWhereToInsert)
	: XmlProcInstrDlgBase(parent, name, bModal)
{
	if(m_strProcInstrTarget.isEmpty())
		m_pPushButtonOk->setEnabled(false);
	else
		m_pPushButtonOk->setEnabled(true);

	m_pEditProcInstrTarget->setFocus();
	m_pPushButtonOk->setDefault(true);
	
	if(bHideComboBoxWhereToInsert)
		{ m_pComboBoxWhereToInsert->hide();
			m_pTextLabelInsert->hide();
		}
}

XmlProcInstrDlg::~XmlProcInstrDlg()
{
}

/** Called, when user press OK button */
void XmlProcInstrDlg::slotOk()
{
	m_strProcInstrTarget = m_pEditProcInstrTarget->text();
	m_strProcInstrData = m_pEditProcInstrData->text();
	m_iWhereToInsert = m_pComboBoxWhereToInsert->currentItem();
	accept();
}

/** Called, when user change targed edit line */
void XmlProcInstrDlg::slotProcInstrTargetChanged(const QString &string)
{
	if(string.isEmpty())
		m_pPushButtonOk->setEnabled(false);
	else
		m_pPushButtonOk->setEnabled(true);
}
