/***************************************************************************
                          searchdlg.cpp  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "searchdlg.h"

#include <qlineedit.h>
#include <qcheckbox.h>
#include <qpushbutton.h>

QString SearchDlg::m_strSearchedString;
bool SearchDlg::m_bMatchCase = false;
bool SearchDlg::m_bElementNames = true;
bool SearchDlg::m_bAttributeNames = false;
bool SearchDlg::m_bAttributeValues = false;
bool SearchDlg::m_bContents = false;

SearchDlg::SearchDlg(QWidget *parent, const char *name, bool modal)
		: SearchDlgBase(parent, name, modal)
{
	if(m_strSearchedString.isEmpty())
		m_pPushButtonFind->setEnabled(false);
	else
		m_pPushButtonFind->setEnabled(true);

	m_pEditSearchedString->setText(m_strSearchedString);
	m_pCheckBoxMatchCase->setChecked(m_bMatchCase);
	m_pCheckBoxElementNames->setChecked(m_bElementNames);
	m_pCheckBoxAttributeNames->setChecked(m_bAttributeNames);
	m_pCheckBoxAttributeValues->setChecked(m_bAttributeValues);
	m_pCheckBoxContents->setChecked(m_bContents);
	
	m_pEditSearchedString->setFocus();
	m_pPushButtonFind->setDefault(true);
}

SearchDlg::~SearchDlg()
{
}

/** Called when user press Find button */
void SearchDlg::slotSearch()
{
	m_strSearchedString = m_pEditSearchedString->text();
	m_bMatchCase = m_pCheckBoxMatchCase->isChecked();
	m_bElementNames = m_pCheckBoxElementNames->isChecked();
	m_bAttributeNames = m_pCheckBoxAttributeNames->isChecked();
	m_bAttributeValues = m_pCheckBoxAttributeValues->isChecked();
	m_bContents = m_pCheckBoxContents->isChecked();

	accept();
}

/** Called when text in edit line is changed */
void SearchDlg::slotTextChanged(const QString &string)
{
	if(string.isEmpty())
		m_pPushButtonFind->setEnabled(false);
	else
		m_pPushButtonFind->setEnabled(true);
}
