/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_TASKMANAGER_H
#define XEPLUGIN_TASKMANAGER_H

#include <qobject.h>
#include <klocale.h>
#include <kwinmodule.h>
#include "taskmanager.h"

#include <stdlib.h>
#include <unistd.h> 

class DCOPClient;


/**
@author Stefano
*/
class XEPlugin_TaskManager : public QObject
{
Q_OBJECT
public:
    XEPlugin_TaskManager(QObject *parent = 0, const char *name = 0);

    ~XEPlugin_TaskManager();
protected:
	class XSConfigurations *ActiveConfiguration;
	class XGDocker	*xGDocker;
	class KWinModule	*KDEWM;
	class TaskManager	*KDETaskManager;
//	Task		*LastThumbnailUpdate;
	int showWindowsOnlyFromThisDesktop;
	int showGroupWindows;
	int autoAddSeparator;
	int thumbnailShowIcon;
	int dcopPollingTimeout;
	DCOPClient    * dcopClient;

public slots:
    void xSetup();
    void xStart();
    void xStop();
    void currentDesktopChanged(int desktop);
    void startupAdded(Startup*);
    void startupRemoved(Startup*);
    void taskAdded(Task*);
    void taskRemoved(Task*);
    void thumbnailChanged(Task *);
    void taskActivated(Task*);
    void xSetupParameter(const QString, const QString);
    void xSetupParameter(const QString sName, int iValue);
    void xGetParameter(const QString, QString&);
    void xGetParameter(const QString, int&);
    void xToggleShowAll();
    void xGetParameterList(QStringList *);
    void dcopPolling();
    void dcop_applicationRemoved(const QCString &);
    void dcop_applicationRegistered(const QCString &);
signals:
    void xEventTaskOpen(int);
    void xEventTaskAppend(int);
    void xEventRemoveIcon(int );
protected:
    void removeIcon(Task *);
protected:
    void clonate(class XSGObjectIcon *,XSGObjectIcon *);
    void gotTaskInCache(class XSGObjectIcon *);
protected:
    void updateXMLcfg(const QString Name);
protected:
    void taskActivatedMultipass(Task *t);
    void taskActivatedCheckTitle(Task *t);
};

#endif
