/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XGICON_H
#define XGICON_H

#include "xeconfiguration.h"


#include <qwidget.h>
#include <qimage.h>
#include <qbitmap.h>
#include <qwmatrix.h>
#include <qpoint.h>
#include <qpixmap.h>

class XEPlugin_GEPillow;

const int MAX_CACHE_ICONS=129;

/**
@author Stefano
*/
class XGIcon : public QWidget
{
Q_OBJECT
public:
    XGIcon(QWidget *parent = 0, const char *name = 0);

    ~XGIcon();
    void xSetHotspot(const QPoint &);
    void xRepeat(int rWidth,int rHeight);
    void xSetIntensity(float);
    void xResetIntensity();
    static int xGetFontHeight();
    void xSetSmoothZoom(int);
    void xStartAnimating();
    void xStopAnimating();
    int isTextDrawed;

public slots:
    void xRedraw();
    void cachePurge();
    void xSetImage(const QString &);
    void xLoadIcon(const QString &);
    void xSetZoom(int,int);
    void xSetZoom(int);
    void xReset();
    void xSetImage(const QPixmap &);
    void xSetClass(QObject *);
    void xSetText(const QString &);
    void xGetImage(QImage *&);
    void xSetSmoothZoom();
    void xGetConfiguration(const XSGObjectIcon *&);
    void xGetPluginConfiguration(const QDomNodeList *&);
    void xDrawText();
    void xSetZoom();
    void createPopup();
    void getPopupMenu(KPopupMenu *&);
    void xStartClass();
    void xSetupClass();

protected:
    //---------------------------------------------------------
    // Cache DATA
    // Will have the Coords for cached Zooms
    // Zoom are cached only if z(x==y)
    //int 	xCachedZoom[MAX_CACHE_ICONS];
    // Transparency channel
    //QBitmap 	xChachedTransparency[MAX_CACHE_ICONS];
    // RGB Image
    //QImage 	xCachedimgShowed[MAX_CACHE_ICONS];
    int		xImgCachedZoom[129];
    QImage	xImgCached[129];
    QObject	*xClassManager;
    
public:
    //---------------------------------------------------------
    // User DATA
    // User Click    
    QPoint 	xHotspot;
    const XSGObjectIcon *iconConfiguration;
    //XSGObjectIcon *iconConfiguration;
    
    short int	xExclude;
    
    int	xAndZoomCache;
    static XSConfigurations * ActiveConfiguration;

    
    //---------------------------------------------------------
    // Paint DATA
    // Current Zoom x=y
    int 	xZoom;
    int 	xZoomX;
    int 	xZoomY;
    // Invalidate Content
    int		xSetUpdate;
    // Showed Image
    QImage 	xImgShowed;
    QImage 	xImgArrow;
    //QImage	xImgText;
    QPixmap xImgText;
    int xTextDecentre;
    // Paint Position
    QPoint 	xPosition;
    QImage	Poof;
    //---------------------------------------------------------
    // Original DATA
    // Source Position
    QPoint 	xPosDefault;
    // Source Transparency
    QBitmap 	xTransparency;
    // Source Image
    QImage 	xImgSource;
    QImage 	xImgOriginal;
    QString	pillowText;
    XEPlugin_GEPillow *xPillow;
signals:
    void xAttach(QObject *);
    void xRefresh(QObject *);
    void xEventStartAnimating();
    void xEventStopAnimating();
    void xStart();
    void xSetup();
};

#endif
