/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_gmounts.h"

#include <kmountpoint.h>
#include <kpopupmenu.h>

#include "xeconfiguration.h"
#include "xgdocker.h"
#include "xgicon.h"

#include "xeplugin_gmounts.moc"


XEPlugin_GMounts::XEPlugin_GMounts(QObject *parent, const char *name)
 : QObject(parent, name)
{
	XEObject::xPluginAdd(this);
	KDEWatch	=new KDirWatch();
}


XEPlugin_GMounts::~XEPlugin_GMounts()
{
}




/*!
    \fn XEPlugin_GMounts::xSetup()
 */
void XEPlugin_GMounts::xSetup()
{
#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GMounts::xSetup()");
#endif
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	//xWarningMsg(this,"error while searching for plugin");
	qWarning("error while searching for plugin");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
}


/*!
    \fn XEPlugin_GMounts::xStart()
 */
void XEPlugin_GMounts::xStart()
{
	
	KMountPoint::List devList=KMountPoint::currentMountPoints();
	KMountPoint *DeviceMounted=NULL;
	for (int i=0;i<devList.count();i++)
	{
		DeviceMounted=devList[i];
		if(DeviceMounted==NULL)break;
#ifndef ENABLE_FINAL
		qWarning(DeviceMounted->mountPoint());
#endif
		
		MountAdded(DeviceMounted->mountPoint());
		
	}
	
	KDEWatch->addFile("/etc/mtab");
	connect(KDEWatch, SIGNAL(dirty(const QString &)),this,SLOT(dirty(const QString &)));
	KDEWatch->startScan();
	
	
}


/*!
    \fn XEPlugin_GMounts::xStop()
 */
void XEPlugin_GMounts::xStop()
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_GMounts::MountAdded(const QString &)
 */
void XEPlugin_GMounts::MountAdded(const QString &newMount)
{
	for(int i=0; i<ActiveConfiguration->Plugins.Matches.count();i++)
	{
		if(ActiveConfiguration->Plugins.Matches.at(i)->SystemName==newMount)
		{
#ifndef ENABLE_FINAL
			qWarning("Matched icon for this mountpoint");
#endif
			// searching if it's being showed
			for(int iconIndex=0;iconIndex<ActiveConfiguration->ObjectsIcons.count();iconIndex++)
			{
#ifndef ENABLE_FINAL
				qWarning("xeplugin_gmounts.cpp:108");
#endif
	if(ActiveConfiguration->ObjectsIcons.at(iconIndex)==NULL)qWarning("void XEPlugin_GMounts::MountAdded(const QString &newMount) [125] Cazzo e' null");
#ifndef ENABLE_FINAL
				qWarning("NON e' null");
				qWarning(ActiveConfiguration->ObjectsIcons.at(iconIndex)->OverText);
#endif
				if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.fileName==newMount)return;
			}
			// copy the informations
#ifndef ENABLE_FINAL
			qWarning("xeplugin_gmounts.cpp:115");
#endif
	// if there are too icons, we can exit because no more will be added
	if(ActiveConfiguration->ObjectsIcons.count()>=ActiveConfiguration->Engine.MaxIconsShowed)return;
			XSGObjectIcon *addedCfg=new XSGObjectIcon;
//			addedCfg->Tasks.PopupMenu=new KPopupMenu();
			addedCfg->Tasks.PopupMenu=NULL;
			addedCfg->PluginPopupMenu=NULL;
			ActiveConfiguration->ObjectsIcons.append(addedCfg);
			ActiveConfiguration->RollingIcons.append(addedCfg);
			

			addedCfg->OverText=ActiveConfiguration->Plugins.Matches.at(i)->Icon->OverText;
			addedCfg->Info.fileName=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.Name=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.Group=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.className=name();
			
			addedCfg->Tasks.Proces.clear();
			
			addedCfg->Tasks.ShowThumbnail=0;
			addedCfg->Tasks.TaskInfo=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.TaskInfo;
			addedCfg->Tasks.TaskName=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.TaskName;
			addedCfg->Tasks.WindowTitle=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.WindowTitle;
			addedCfg->Images=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Images;
			addedCfg->Actions=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Actions;
//			ActiveConfiguration->ObjectsIcons.count()++;
			xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
		}
	}
}


/*!
    \fn XEPlugin_GMounts::dirty(const QString &)
 */
void XEPlugin_GMounts::dirty(const QString &)
{
	KMountPoint::List devList=KMountPoint::currentMountPoints();
	KMountPoint *DeviceMounted=NULL;
	for (int i=0;i<devList.count();i++)
	{
		DeviceMounted=devList[i];
		if(DeviceMounted==NULL)break;
		qWarning(DeviceMounted->mountPoint());
		
		MountAdded(DeviceMounted->mountPoint());
		
	}
	// ok now removing the old one
	int indexfind;
	for(int iconIndex=0;iconIndex<ActiveConfiguration->ObjectsIcons.count();iconIndex++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className==name())
		{
			indexfind=-1;
			for (int i=0;i<devList.count();i++)
			{
				DeviceMounted=devList[i];
				if(DeviceMounted==NULL)break;
				
if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.fileName==DeviceMounted->mountPoint()){
					indexfind=i;
					break;
				}
			}
			if(indexfind<0)
			{
				// remove it
				xGDocker->iconRemove(iconIndex);
			}
		}
	}
	
}


/*!
    \fn XEPlugin_GMounts::xGetParameter(const QString,QString&)
 */
void XEPlugin_GMounts::xGetParameter(const QString,QString&)
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_GMounts::xGetParameterList(QStringList*)
 */
void XEPlugin_GMounts::xGetParameterList(QStringList*)
{
    /// @todo implement me
}
