#!/bin/bash

KXDRSCVER="KXDocker 0.21"
TARGET="kxdocker"

echo "KXDocker installer for" $KXDRSCVER

find_KDE_global()
{
	MYKDE="$1"

	if ! [ "$MYKDE" == "" ];
	then
		echo "$MYKDE";
		return;
	fi

	if ! [ "$KDEDIR" == "" ];
	then
		MYKDE="$KDEDIR";
	echo "$MYKDE"
		return;
	fi

	MYKDE=`kde-config --prefix`
	echo "$MYKDE"
	return;
}

find_KDE_local()
{
	MYKDE="$1"

	if ! [ "$MYKDE" == "" ];
	then
		echo "$MYKDE";
		return;
	fi

	MYKDE=`kde-config --localprefix`
	echo "$MYKDE"
	return;
}

checkcompile()
{
	if [ ! -x $TARGET ];
	then
		SURE3=`kdialog --yesno "Do you like to compile the KXDocker ? (pass 1/1)" && echo "yes"`;
		if [ "$SURE3" == "yes" ];
		then
			./compile.sh
		fi
		
	fi
	if [ ! -x $TARGET ];
	then
		kdialog --error "Error while compiling the KXDocker! you must do manually" && exit 1
	fi
	
	TARGETPATH=`kdialog --inputbox "Where do you like to install KXDocker? (pass 1/2)" "${KXDPREFIX}/bin/kxdocker"`

	SURE2=`kdialog --yesno "Do you like to install KXDocker into: $TARGETPATH? (pass 2/2)" && echo "yes"`;
	if [ "$SURE2" == "yes" ];
	then
		! cp $TARGET $TARGETPATH && kdialog --error "Error while installing KXDocker: $TARGETPATH/$TARGET" && exit 1
		
		kdialog --msgbox "Installation successfully into: $TARGETPATH/$TARGET"
	fi

}


if ! [ "$DISPLAY" == "" ];
then
	kdialog --msgbox "KXDocker installer $KXDRSCVER";
	KXDPREFIX=`find_KDE_global`
	checkcompile
else
	echo "You have to run this script under X environment with KDE correctly installed";
	exit 1;
fi

