#include "kwlanmaintraywin.h"
#include "kwlanmainwin.h"
#include "kwlanmainsettingsdlg.h"
#include "configuration.h"



#include <kstdaction.h>
#include <kpopupmenu.h>
#include <kaction.h>
#include <qtooltip.h>
#include <kiconloader.h>
#include <qpixmap.h>
#include <klocale.h>
#include <kdebug.h>




/// KWlanMainTrayWin is tray window for main application

KWlanMainTrayWin::KWlanMainTrayWin(QWidget *parent, const char *name)
    : KSystemTray(parent, name)
{
    //actionCollection()->remove( actionCollection()->action( "quit" ) );
    m_quit = KStdAction::quit( this, SIGNAL( quitSelected() ), actionCollection() );
    m_about = KStdAction::aboutApp( this, SIGNAL( aboutSelected() ), actionCollection() );
    m_interfacesMenu = new KPopupMenu();
    m_settingsMenu = new KAction(this,"settings");
    connect (m_interfacesMenu, SIGNAL(activated(int )),SLOT(slotHandleInterfacesMenu( int )));
    connect (m_settingsMenu, SIGNAL(activated()),SLOT(slotSettingsMenu()));

    setPixmap(loadIcon("kwlan"));
    m_tooltip = new KWlanMainToolTip(this);
}

KWlanMainTrayWin::~KWlanMainTrayWin() {
}

void KWlanMainTrayWin::contextMenuAboutToShow( KPopupMenu *r ) 
{
    r->clear();
    r->insertTitle(SmallIcon ("kwlan"), "Kwlan - KDE Connection Manager");
    m_interfacesMenu->clear();
    if (parent())
    {
        int id = 1;
        QStringList interfaces = ((KWlanMainWin *)parent())->getInterfaces();
        for (QStringList::iterator it = interfaces.begin(); it !=interfaces.end();it++)
        {
            m_interfacesMenu->insertItem(*it,id);
            m_interfacesMenu->setItemParameter(id,id);
            m_interfacesMenu->setItemChecked(id, mainConfiguration().readMonitorInterface( *it));
            id++;
        }
        r->insertItem(i18n("Monitor interfaces"),m_interfacesMenu);

    }
    m_settingsMenu->setText(i18n("Settings"));
    m_settingsMenu->plug(r);
    r->insertSeparator();
    // Now fill int the profiles into profile menu
    m_about->plug( r );
    m_quit->plug( r );
    
}

void KWlanMainTrayWin::slotHandleInterfacesMenu( int id)
{
    kdDebug()<< "Monitor interface " <<m_interfacesMenu->text(id) << endl;
    mainConfiguration().writeMonitorInterface( m_interfacesMenu->text(id), !m_interfacesMenu->isItemChecked(id));
    emit sigMonitorInterface( m_interfacesMenu->text(id),!m_interfacesMenu->isItemChecked(id));
}

void KWlanMainTrayWin::slotSettingsMenu()
{
    KWlanMainSettingsDlg *settings = new KWlanMainSettingsDlg();
    if (!settings) return;
    settings->show();
    settings->exec();
}

KWlanMainToolTip::KWlanMainToolTip(QWidget *parent): QToolTip(parent) {
}
    
KWlanMainToolTip::~KWlanMainToolTip() {
    
}
        
void KWlanMainToolTip::maybeTip(const QPoint &p) {
    QString tooltip;
    tooltip = QString(i18n("Kwlan - Network manager for KDE"));
    tip(parentWidget()->rect(), tooltip);
}

