/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef NETWORKINTERFACE_H
#define NETWORKINTERFACE_H

#include <qwidget.h>
#include <qprocess.h>
#include <qstringlist.h>
#include <qobject.h>
#include <qapplication.h>
#include <ktempfile.h>
#include <qhttp.h>
#include <qstringlist.h>
#include "kvpncconfig.h"

/**
Class for interaction with network interface

@author Christoph Thielecke
*/
class NetworkInterface : public QObject
{
	Q_OBJECT

public:
	/**
	 *     Konstruktor
	 * @param parent Pointer to parent widget
	 * @param name Name of the object
	 * @return nothing
	 */
	NetworkInterface( KVpncConfig* config,QApplication *app, QObject *parent = 0, const char *name = 0 );

	/**
	 *     Destruktor
	 * @return nothing
	 */
	~NetworkInterface();

	/**
	 *     Tests if the interface exists
	 * @param Interface The interface to test
	 * @return True if interface exist
	 */
	bool interfaceExist(QString Interface);

	/**
	 *     Retrieves a list of all availiable interfaces
	 * @return List with all interfaces
	 */
	QStringList getAllNetworkInterfaces();

	/**
	 *     Gets the IP from a given interface
	 * @param Interface The interface from which the IP whould be given
	 * @return The IP
	 */
	QString getInterfaceIP(QString Interface);

	/**
	 *     Gets the device from a given IP
	 * @param IP The IP which the target interface has
	 * @return The interface where the IP is set
	 */
	QString getInterfaceAddress(QString IP);

	/**
	 *     Gets the interface where the default route points
	 * @return The interface
	 */
	QString getDefaultInterface();

	/**
	 *     Gets the gateway of a given interface
	 * @return The interface
	 */
	QString getGatewayOfInterface(QString interface);

	/**
	 *     Gets the gateway of the default route
	 * @return The interface
	 */
	QString getGatewayOfDefaultInterface();

	/**
	 *    Gets the IP address which is used for communication with internet connections (same as local address if not behind router)
	 * @return The external IP address
	 */
	QString  getExternalIpAddress();

public slots:
	void readFromStdout();
	void readFromStderr();
	void processHasFinished();
	void externalIpDataRecieved(const QHttpResponseHeader & resp);

protected:
	QProcess *proc; //< The process for starting external programs
	QProcess *InterfaceExitsProc;
	bool interfaceTest; //< True if interface test is running
	
	bool retrieveInterfaceAddress; //< True if retrieve interface address is running
	QStringList InterfaceList; //< List with interfaces
	QString InterfaceIP; //< IP for interface
	QString InterfaceAddress; //< Device for IP
	QString GatewayAddress; //< Gateway of Device
	QString GatewayOfInterfaceAddress;
	QString GatewayOfDefaultInterfaceAddress; //< Gateway of Device
	bool interfaceExists; //< True if interface exists
	QString ifconfigbin; //< Path to ifconfig
	QString routebin; //< Path to route
	QString defaultinterface; //< Interface with defaultroute
	QString IPforInterface; //< The Ip for interface
	QString tmpInterface; //< Interface for getting devname
	QApplication *app;
	bool readOutput,getExternalIpAddressRunning;
	KTempFile *tmpfile;
	QHttp *http;
	QString ExternalIpAddress;
	QStringList *env;
	KVpncConfig *GlobalConfig;
};

#endif
