/* Copyright 2001 Red Hat, Inc.
 *
 * This software may be freely redistributed under the terms of the GNU
 * public license.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _KUDZU_MISC_H_
#define _KUDZU_MISC_H_

#include "device.h"

struct miscDevice {
    /* common fields */
    struct device *next;	/* next device in list */
	int index;
    enum deviceClass class;	/* type */
    enum deviceBus bus;		/* bus it's attached to */
    char * device;		/* device file associated with it */
    char * driver;		/* driver to load, if any */
    char * desc;		/* a description */
	int detached;
    /* misc-specific fields */
    struct miscDevice *(*newDevice) (struct miscDevice *dev);
    void (*freeDevice) (struct miscDevice *dev);
    void (*writeDevice) (FILE *file, struct miscDevice *dev);
	int (*compareDevice) (struct miscDevice *dev1, struct miscDevice *dev2);
};

struct miscDevice *miscNewDevice(struct miscDevice *dev);
struct device *miscProbe(enum deviceClass probeClass, int probeFlags,
			struct device *devlist);

#endif
