/***************************************************************************
                          texkonsolewidget.cpp  -  description
                             -------------------
    begin                : Sat Dec 8 2001
    copyright            : (C) 2001 by Brachet Pascal
    email                : pascal.brachet@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "texkonsolewidget.h"
#include <qlayout.h>
#include <qframe.h>
#include <kglobalsettings.h>

TexKonsoleWidget::TexKonsoleWidget(QWidget *parentWidget, const char *widgetName) : QWidget(parentWidget,widgetName)
{

  QVBoxLayout *vbox = new QVBoxLayout(this,2);

  KeyTrans::loadAll();
  QStrList eargs;
  const char* shell = "/bin/sh";
  eargs.append(shell);
  te = new TEWidget(this,widgetName);
  te->setScrollbarLocation(TEWidget::SCRRIGHT);
	te->setFrameStyle(QFrame::Panel|QFrame::Sunken);
  vbox->addWidget(te);

  initial = new TESession((KMainWindow*)this,te,shell,eargs,"xterm");
  connect( initial,SIGNAL(done(TESession*,int)),this,SLOT(doneSession(TESession*,int)) );
  initial->setConnect(TRUE);
  te->currentSession = initial;
  te->setVTFont(KGlobalSettings::fixedFont());
  ColorEntry ctable[TABLE_COLORS];
  memcpy(ctable, te->getColorTable(), sizeof(ctable));
  if (ctable)
    {
      ctable[DEFAULT_BACK_COLOR]=ColorEntry(QColor(0xFF,0xFF,0xDD), 1, 0 ) ;
      ctable[DEFAULT_FORE_COLOR]=ColorEntry(QColor(0x00,0x00,0x00), 0, 0 ) ;
//      ctable[DEFAULT_BACK_COLOR].color = KGlobalSettings::baseColor();
//      ctable[DEFAULT_FORE_COLOR].color = KGlobalSettings::textColor();
      te->setColorTable(ctable);
    }

  initial->setHistory(HistoryTypeBlockArray(1000));
  initial->run();
  connect( initial, SIGNAL( destroyed() ), this, SLOT( sessionDestroyed() ) );
}

TexKonsoleWidget::~TexKonsoleWidget()
{
  if ( initial )
  {
    disconnect( initial, SIGNAL( destroyed() ), this, SLOT( sessionDestroyed() ) );
    delete initial;
  }
}

void TexKonsoleWidget::LaunchCommand(QString command)
{
 QKeyEvent e(QEvent::KeyPress, 0,-1,0, command);
 initial->getEmulation()->onKeyPress(&e);
}

void TexKonsoleWidget::doneSession(TESession*,int)
{
  if (initial)
  {
    disconnect( initial,SIGNAL(done(TESession*,int)),this,SLOT(doneSession(TESession*,int)) );
    initial->setConnect(FALSE);
    initial->terminate();
  }
}

void TexKonsoleWidget::sessionDestroyed()
{
  disconnect( initial, SIGNAL( destroyed() ), this, SLOT( sessionDestroyed() ) );
  initial = 0;
  delete this;
}
