/**********************************************************************

	--- Qt Architect generated file ---

	File: ticsOp.cpp

    Xgfe: X Windows GUI front end to Gnuplot
    Copyright (C) 1998 David Ishee

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 *********************************************************************/

#include "ticsOp.h"

#define Inherited ticsOpData

ticsOp::ticsOp
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "Tics Options" );
}


ticsOp::~ticsOp()
{
}

void ticsOp::setGnuInterface(gnuInterface* gnu)
{
  gnuInt = gnu;

  // get options
  int xticsOnFlag = gnuInt->getXticsOnFlag();
  string xticsLocation = gnuInt->getXticsLocation();
  string xticsMirror = gnuInt->getXticsMirror();
  string xticsRotation = gnuInt->getXticsRotation();
  string xticsPositionType = gnuInt->getXticsPositionType();
  string xticsStartPos = gnuInt->getXticsStartPos();
  string xticsIncPos = gnuInt->getXticsIncPos();
  string xticsEndPos = gnuInt->getXticsEndPos();
  string xticsLabelsPos = gnuInt->getXticsLabelsPos();

  int yticsOnFlag = gnuInt->getYticsOnFlag();
  string yticsLocation = gnuInt->getYticsLocation();
  string yticsMirror = gnuInt->getYticsMirror();
  string yticsRotation = gnuInt->getYticsRotation();
  string yticsPositionType = gnuInt->getYticsPositionType();
  string yticsStartPos = gnuInt->getYticsStartPos();
  string yticsIncPos = gnuInt->getYticsIncPos();
  string yticsEndPos = gnuInt->getYticsEndPos();
  string yticsLabelsPos = gnuInt->getYticsLabelsPos();

  int zticsOnFlag = gnuInt->getZticsOnFlag();
  string zticsMirror = gnuInt->getZticsMirror();
  string zticsRotation = gnuInt->getZticsRotation();
  string zticsPositionType = gnuInt->getZticsPositionType();
  string zticsStartPos = gnuInt->getZticsStartPos();
  string zticsIncPos = gnuInt->getZticsIncPos();
  string zticsEndPos = gnuInt->getZticsEndPos();
  string zticsLabelsPos = gnuInt->getZticsLabelsPos();

  int x2ticsOnFlag = gnuInt->getX2ticsOnFlag();
  string x2ticsLocation = gnuInt->getX2ticsLocation();
  string x2ticsMirror = gnuInt->getX2ticsMirror();
  string x2ticsRotation = gnuInt->getX2ticsRotation();
  string x2ticsPositionType = gnuInt->getX2ticsPositionType();
  string x2ticsStartPos = gnuInt->getX2ticsStartPos();
  string x2ticsIncPos = gnuInt->getX2ticsIncPos();
  string x2ticsEndPos = gnuInt->getX2ticsEndPos();
  string x2ticsLabelsPos = gnuInt->getX2ticsLabelsPos();

  int y2ticsOnFlag = gnuInt->getY2ticsOnFlag();
  string y2ticsLocation = gnuInt->getY2ticsLocation();
  string y2ticsMirror = gnuInt->getY2ticsMirror();
  string y2ticsRotation = gnuInt->getY2ticsRotation();
  string y2ticsPositionType = gnuInt->getY2ticsPositionType();
  string y2ticsStartPos = gnuInt->getY2ticsStartPos();
  string y2ticsIncPos = gnuInt->getY2ticsIncPos();
  string y2ticsEndPos = gnuInt->getY2ticsEndPos();
  string y2ticsLabelsPos = gnuInt->getY2ticsLabelsPos();

  // set xtics options
  if (xticsOnFlag == 1)
  {
    xticsOnRButton->setChecked(TRUE);
    xticsOffRButton->setChecked(FALSE);
  }
  else if (xticsOnFlag == 0)
  {
    xticsOnRButton->setChecked(FALSE);
    xticsOffRButton->setChecked(TRUE);
  }

  if (xticsLocation == "border")
    xticsLocationCBox->setCurrentItem(0);

  if (xticsLocation == "axis")
    xticsLocationCBox->setCurrentItem(1);

  if (xticsMirror == "mirror")
    xticsMirrorCBox->setCurrentItem(0);
  
  if (xticsMirror == "nomirror")
    xticsMirrorCBox->setCurrentItem(1);
  
  if (xticsRotation == "norotate")
    xticsRotationCBox->setCurrentItem(0);

  if (xticsRotation == "rotate")
    xticsRotationCBox->setCurrentItem(1);

  if (xticsPositionType == "SIE")
  {
    xticsSIERadioButton->setChecked(TRUE);
    xticsLabelPosRButton->setChecked(FALSE);

    xticsStartPosEdit->setText(xticsStartPos.c_str());
    xticsIncPosEdit->setText(xticsIncPos.c_str());
    xticsEndPosEdit->setText(xticsEndPos.c_str());
  }
  else if (xticsPositionType == "LABELS")
  {
    xticsSIERadioButton->setChecked(FALSE);
    xticsLabelPosRButton->setChecked(TRUE);

    xticsLabelsPosEdit->setText(xticsLabelsPos.c_str());
  }
  
  // set ytics options
  if (yticsOnFlag == 1)
  {
    yticsOnRButton->setChecked(TRUE);
    yticsOffRButton->setChecked(FALSE);
  }
  else if (yticsOnFlag == 0)
  {
    yticsOnRButton->setChecked(FALSE);
    yticsOffRButton->setChecked(TRUE);
  }

  if (yticsLocation == "border")
    yticsLocationCBox->setCurrentItem(0);

  if (yticsLocation == "axis")
    yticsLocationCBox->setCurrentItem(1);

  if (yticsMirror == "mirror")
    yticsMirrorCBox->setCurrentItem(0);

  if (yticsMirror == "nomirror")
    yticsMirrorCBox->setCurrentItem(1);
  
  if (yticsRotation == "norotate")
    yticsRotationCBox->setCurrentItem(0);

  if (yticsRotation == "rotate")
    yticsRotationCBox->setCurrentItem(1);

  if (yticsPositionType == "SIE")
  {
    yticsSIERadioButton->setChecked(TRUE);
    yticsLabelPosRButton->setChecked(FALSE);

    yticsStartPosEdit->setText(yticsStartPos.c_str());
    yticsIncPosEdit->setText(yticsIncPos.c_str());
    yticsEndPosEdit->setText(yticsEndPos.c_str());
  }
  else if (yticsPositionType == "LABELS")
  {
    yticsSIERadioButton->setChecked(FALSE);
    yticsLabelPosRButton->setChecked(TRUE);

    yticsLabelsPosEdit->setText(yticsLabelsPos.c_str());
  }
  
  // set ztics options
  if (zticsOnFlag == 1)
  {
    zticsOnRButton->setChecked(TRUE);
    zticsOffRButton->setChecked(FALSE);
  }
  else if (zticsOnFlag == 0)
  {
    zticsOnRButton->setChecked(FALSE);
    zticsOffRButton->setChecked(TRUE);
  }

  if (zticsMirror == "mirror")
    zticsMirrorCBox->setCurrentItem(0);
  
  if (zticsMirror == "nomirror")
    zticsMirrorCBox->setCurrentItem(1);
  
  if (zticsRotation == "norotate")
    zticsRotationCBox->setCurrentItem(0);

  if (zticsRotation == "rotate")
    zticsRotationCBox->setCurrentItem(1);

  if (zticsPositionType == "SIE")
  {
    zticsSIERadioButton->setChecked(TRUE);
    zticsLabelPosRButton->setChecked(FALSE);

    zticsStartPosEdit->setText(zticsStartPos.c_str());
    zticsIncPosEdit->setText(zticsIncPos.c_str());
    zticsEndPosEdit->setText(zticsEndPos.c_str());
  }
  else if (zticsPositionType == "LABELS")
  {
    zticsSIERadioButton->setChecked(FALSE);
    zticsLabelPosRButton->setChecked(TRUE);

    zticsLabelsPosEdit->setText(zticsLabelsPos.c_str());
  }
  
  // set x2tics options
  if (x2ticsOnFlag == 1)
  {
    x2ticsOnRButton->setChecked(TRUE);
    x2ticsOffRButton->setChecked(FALSE);
  }
  else if (x2ticsOnFlag == 0)
  {
    x2ticsOnRButton->setChecked(FALSE);
    x2ticsOffRButton->setChecked(TRUE);
  }

  if (x2ticsLocation == "border")
    x2ticsLocationCBox->setCurrentItem(0);
  
  if (x2ticsLocation == "axis")
    x2ticsLocationCBox->setCurrentItem(1);
  
  if (x2ticsMirror == "mirror")
    x2ticsMirrorCBox->setCurrentItem(0);
  
  if (x2ticsMirror == "nomirror")
    x2ticsMirrorCBox->setCurrentItem(1);
  
  if (x2ticsRotation == "norotate")
    x2ticsRotationCBox->setCurrentItem(0);

  if (x2ticsRotation == "rotate")
    x2ticsRotationCBox->setCurrentItem(1);

  if (x2ticsPositionType == "SIE")
  {
    x2ticsSIERadioButton->setChecked(TRUE);
    x2ticsLabelPosRButton->setChecked(FALSE);

    x2ticsStartPosEdit->setText(x2ticsStartPos.c_str());
    x2ticsIncPosEdit->setText(x2ticsIncPos.c_str());
    x2ticsEndPosEdit->setText(x2ticsEndPos.c_str());
  }
  else if (x2ticsPositionType == "LABELS")
  {
    x2ticsSIERadioButton->setChecked(FALSE);
    x2ticsLabelPosRButton->setChecked(TRUE);

    x2ticsLabelsPosEdit->setText(x2ticsLabelsPos.c_str());
  }
  
  // set y2tics options
  if (y2ticsOnFlag == 1)
  {
    y2ticsOnRButton->setChecked(TRUE);
    y2ticsOffRButton->setChecked(FALSE);
  }
  else if (y2ticsOnFlag == 0)
  {
    y2ticsOnRButton->setChecked(FALSE);
    y2ticsOffRButton->setChecked(TRUE);
  }

  if (y2ticsLocation == "border")
    y2ticsLocationCBox->setCurrentItem(0);
  
  if (y2ticsLocation == "axis")
    y2ticsLocationCBox->setCurrentItem(1);
  
  if (y2ticsMirror == "mirror")
    y2ticsMirrorCBox->setCurrentItem(0);
  
  if (y2ticsMirror == "nomirror")
    y2ticsMirrorCBox->setCurrentItem(1);
  
  if (y2ticsRotation == "norotate")
    y2ticsRotationCBox->setCurrentItem(0);

  if (y2ticsRotation == "rotate")
    y2ticsRotationCBox->setCurrentItem(1);

  if (y2ticsPositionType == "SIE")
  {
    y2ticsSIERadioButton->setChecked(TRUE);
    y2ticsLabelPosRButton->setChecked(FALSE);

    y2ticsStartPosEdit->setText(y2ticsStartPos.c_str());
    y2ticsIncPosEdit->setText(y2ticsIncPos.c_str());
    y2ticsEndPosEdit->setText(y2ticsEndPos.c_str());
  }
  else if (y2ticsPositionType == "LABELS")
  {
    y2ticsSIERadioButton->setChecked(FALSE);
    y2ticsLabelPosRButton->setChecked(TRUE);

    y2ticsLabelsPosEdit->setText(y2ticsLabelsPos.c_str());
  }
  
}

void ticsOp::setTicsOptions()
{
  // get and set options

  // xtics
  if (xticsOnRButton->isChecked() == TRUE)
    gnuInt->setXticsOnFlag(1);
  
  if (xticsOnRButton->isChecked() == FALSE)
    gnuInt->setXticsOnFlag(0);

  string xticsLocation = xticsLocationCBox->currentText().data();
  string xticsMirror = xticsMirrorCBox->currentText().data();
  string xticsRotation = xticsRotationCBox->currentText().data();

  string xticsPositionType;

  if (xticsSIERadioButton->isChecked() == TRUE)
    xticsPositionType = "SIE";

  if (xticsLabelPosRButton->isChecked() == TRUE)
    xticsPositionType = "LABELS";

  string xticsStartPos = xticsStartPosEdit->text().data();
  string xticsIncPos = xticsIncPosEdit->text().data();
  string xticsEndPos = xticsEndPosEdit->text().data();
  string xticsLabelsPos = xticsLabelsPosEdit->text().data();

  gnuInt->setXticsLocation(xticsLocation);
  gnuInt->setXticsMirror(xticsMirror);
  gnuInt->setXticsRotation(xticsRotation);
  gnuInt->setXticsPositionType(xticsPositionType);
  gnuInt->setXticsStartPos(xticsStartPos);
  gnuInt->setXticsIncPos(xticsIncPos);
  gnuInt->setXticsEndPos(xticsEndPos);
  gnuInt->setXticsLabelsPos(xticsLabelsPos);

  // ytics
  if (yticsOnRButton->isChecked() == TRUE)
    gnuInt->setYticsOnFlag(1);

  if (yticsOnRButton->isChecked() == FALSE)
    gnuInt->setYticsOnFlag(0);

  string yticsLocation = yticsLocationCBox->currentText().data();
  string yticsMirror = yticsMirrorCBox->currentText().data();
  string yticsRotation = yticsRotationCBox->currentText().data();

  string yticsPositionType;

  if (yticsSIERadioButton->isChecked() == TRUE)
    yticsPositionType = "SIE";

  if (yticsLabelPosRButton->isChecked() == TRUE)
    yticsPositionType = "LABELS";

  string yticsStartPos = yticsStartPosEdit->text().data();
  string yticsIncPos = yticsIncPosEdit->text().data();
  string yticsEndPos = yticsEndPosEdit->text().data();
  string yticsLabelsPos = yticsLabelsPosEdit->text().data();

  gnuInt->setYticsLocation(yticsLocation);
  gnuInt->setYticsMirror(yticsMirror);
  gnuInt->setYticsRotation(yticsRotation);
  gnuInt->setYticsPositionType(yticsPositionType);
  gnuInt->setYticsStartPos(yticsStartPos);
  gnuInt->setYticsIncPos(yticsIncPos);
  gnuInt->setYticsEndPos(yticsEndPos);
  gnuInt->setYticsLabelsPos(yticsLabelsPos);

  // ztics
  if (zticsOnRButton->isChecked() == TRUE)
    gnuInt->setZticsOnFlag(1);

  if (zticsOnRButton->isChecked() == FALSE)
    gnuInt->setZticsOnFlag(0);

  string zticsMirror = zticsMirrorCBox->currentText().data();
  string zticsRotation = zticsRotationCBox->currentText().data();

  string zticsPositionType;

  if (zticsSIERadioButton->isChecked() == TRUE)
    zticsPositionType = "SIE";

  if (zticsLabelPosRButton->isChecked() == TRUE)
    zticsPositionType = "LABELS";

  string zticsStartPos = zticsStartPosEdit->text().data();
  string zticsIncPos = zticsIncPosEdit->text().data();
  string zticsEndPos = zticsEndPosEdit->text().data();
  string zticsLabelsPos = zticsLabelsPosEdit->text().data();

  gnuInt->setZticsMirror(zticsMirror);
  gnuInt->setZticsRotation(zticsRotation);
  gnuInt->setZticsPositionType(zticsPositionType);
  gnuInt->setZticsStartPos(zticsStartPos);
  gnuInt->setZticsIncPos(zticsIncPos);
  gnuInt->setZticsEndPos(zticsEndPos);
  gnuInt->setZticsLabelsPos(zticsLabelsPos);

  // x2tics
  if (x2ticsOnRButton->isChecked() == TRUE)
    gnuInt->setX2ticsOnFlag(1);

  if (x2ticsOnRButton->isChecked() == FALSE)
    gnuInt->setX2ticsOnFlag(0);

  string x2ticsLocation = x2ticsLocationCBox->currentText().data();
  string x2ticsMirror = x2ticsMirrorCBox->currentText().data();
  string x2ticsRotation = x2ticsRotationCBox->currentText().data();

  string x2ticsPositionType;

  if (x2ticsSIERadioButton->isChecked() == TRUE)
    x2ticsPositionType = "SIE";

  if (x2ticsLabelPosRButton->isChecked() == TRUE)
    x2ticsPositionType = "LABELS";

  string x2ticsStartPos = x2ticsStartPosEdit->text().data();
  string x2ticsIncPos = x2ticsIncPosEdit->text().data();
  string x2ticsEndPos = x2ticsEndPosEdit->text().data();
  string x2ticsLabelsPos = x2ticsLabelsPosEdit->text().data();

  gnuInt->setX2ticsLocation(x2ticsLocation);
  gnuInt->setX2ticsMirror(x2ticsMirror);
  gnuInt->setX2ticsRotation(x2ticsRotation);
  gnuInt->setX2ticsPositionType(x2ticsPositionType);
  gnuInt->setX2ticsStartPos(x2ticsStartPos);
  gnuInt->setX2ticsIncPos(x2ticsIncPos);
  gnuInt->setX2ticsEndPos(x2ticsEndPos);
  gnuInt->setX2ticsLabelsPos(x2ticsLabelsPos);

  // y2tics
  if (y2ticsOnRButton->isChecked() == TRUE)
    gnuInt->setY2ticsOnFlag(1);

  if (y2ticsOnRButton->isChecked() == FALSE)
    gnuInt->setY2ticsOnFlag(0);

  string y2ticsLocation = y2ticsLocationCBox->currentText().data();
  string y2ticsMirror = y2ticsMirrorCBox->currentText().data();
  string y2ticsRotation = y2ticsRotationCBox->currentText().data();

  string y2ticsPositionType;

  if (y2ticsSIERadioButton->isChecked() == TRUE)
    y2ticsPositionType = "SIE";

  if (y2ticsLabelPosRButton->isChecked() == TRUE)
    y2ticsPositionType = "LABELS";

  string y2ticsStartPos = y2ticsStartPosEdit->text().data();
  string y2ticsIncPos = y2ticsIncPosEdit->text().data();
  string y2ticsEndPos = y2ticsEndPosEdit->text().data();
  string y2ticsLabelsPos = y2ticsLabelsPosEdit->text().data();

  gnuInt->setY2ticsLocation(y2ticsLocation);
  gnuInt->setY2ticsMirror(y2ticsMirror);
  gnuInt->setY2ticsRotation(y2ticsRotation);
  gnuInt->setY2ticsPositionType(y2ticsPositionType);
  gnuInt->setY2ticsStartPos(y2ticsStartPos);
  gnuInt->setY2ticsIncPos(y2ticsIncPos);
  gnuInt->setY2ticsEndPos(y2ticsEndPos);
  gnuInt->setY2ticsLabelsPos(y2ticsLabelsPos);
}
