/* -------------------------- gnuMultiFile class --------------------------

   This class handles all operations related to the storage and retrieval of 
   multiple files and their options. These should be called from
   gnuInterface. This class allows you to implement the storage in any way
   you choose. 

   This file is part of Xgfe: X Windows GUI front end to Gnuplot
   Copyright (C) 1998 David Ishee

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ------------------------------------------------------------------------*/
using namespace std;

#include <string>
#include "gnuPlotFile.h"
#include <qdict.h> // Qt's dictionary data structure

class gnuMultiFile
{
public:
  gnuMultiFile();
  // Constructor function

  void insertMultiFileNew(string filename);
  /* Incoming arguments:
       string filename: new filename
     Outgoing arguments:
       none
     Description:
       Inserts a new file into multiple file list */

  void removeMultiFile(string filename);
  /* Incoming arguments:
       string filename: file to remove
     Outgoing arguments:
       none
     Description:
       Removes file from multiple file list */

  void setMultiFileDataSetStart(string filename, string start);
  string getMultiFileDataSetStart(string filename);
  void setMultiFileDataSetEnd(string filename,string end);
  string getMultiFileDataSetEnd(string filename);
  void setMultiFileDataSetIncrement(string filename,string inc);
  string getMultiFileDataSetIncrement(string filename);
  void setMultiFileSampPointInc(string filename,string pinc);
  string getMultiFileSampPointInc(string filename);
  void setMultiFileSampLineInc(string filename,string linc);
  string getMultiFileSampLineInc(string filename);
  void setMultiFileSampStartPoint(string filename,string startp);
  string getMultiFileSampStartPoint(string filename);
  void setMultiFileSampStartLine(string filename,string startl);
  string getMultiFileSampStartLine(string filename);
  void setMultiFileSampEndPoint(string filename,string endp);
  string getMultiFileSampEndPoint(string filename);
  void setMultiFileSampEndLine(string filename,string endl);
  string getMultiFileSampEndLine(string filename);
  void setMultiFileSmoothType(string filename,string type);
  string getMultiFileSmoothType(string filename);

  void insertMultiFileXColumnOption(string filename, string xcol);
  /* Incoming arguments:
       string filename: file to operate on
       string xcol: X column to plot
     Outgoing arguments:
       none
     Description:
       Sets x column for a given file in the multiple file list */

  string getMultiFileXColumnOption(string filename);
  /* Incoming arguments:
       string filename: file to operate on
     Outgoing arguments:
       string: x column for given file
     Description:
       Return x column for a given file in the multiple file list */  

  void insertMultiFileYColumnOption(string filename, string ycol);
  /* Incoming arguments:
       string filename: file to operate on       
       string ycol: Y column to plot
     Outgoing arguments:
       none       
     Description:
       Sets y column for a given file in the multiple file list */

  string getMultiFileYColumnOption(string filename);
  /* Incoming arguments:
       string filename: file to operate on       
     Outgoing arguments:
       string: y column for a given file
     Description:
       Return y column for a given file in the multiple file list */

  void insertMultiFileZColumnOption(string filename, string zcol);
  /* Incoming arguments:
       string filename: file to operate on       
       string zcol: Z column to plot
     Outgoing arguments:
       none       
     Description:
       Sets z column for a given file in the multiple file list */

  string getMultiFileZColumnOption(string filename);
  /* Incoming arguments:
       string filename: file to operate on       
     Outgoing arguments:
       string: z column for the given file
     Description:
       Return z column for a given file in the multiple file list */

  void insertMultiFileFormatOption(string filename, string format);
  /* Incoming arguments:
       string filename: file to operate on       
       string format: format for plotting
     Outgoing arguments:
       none       
     Description:
       Set format for the given file in the multiple file list */

  string getMultiFileFormatOption(string filename);
  /* Incoming arguments:
       string filename: file to operate on       
     Outgoing arguments:
       string: format for given file
     Description:
       Returns format for the given file in the multiple file list */

  void insertMultiFileRawFormatOption(string filename, string format);
  /* Incoming arguments:
       string filename: file to operate on       
       string format: raw format string for plotting
     Outgoing arguments:
       none       
     Description:
       Set raw format for the given file in the multiple file list */

  string getMultiFileRawFormatOption(string filename);
  /* Incoming arguments:
       string filename: file to operate on       
     Outgoing arguments:
       string: raw format for given file
     Description:
       Returns raw format for the given file in the multiple file list */

  void setMultiFileStyleOption(string filename, string style);
  /* Incoming arguments:
       string filename: file to operate on       
       string format: style string for plotting
     Outgoing arguments:
       none       
     Description:
       Set style for the given file in the multiple file list */

  string getMultiFileStyleOption(string filename);
  /* Incoming arguments:
       string filename: file to operate on       
     Outgoing arguments:
       string: style for given file
     Description:
       Returns style for the given file in the multiple file list */

  void setMultiFileFilter(string filename, string filter);
  /* Incoming arguments:
       string filename: filename to operate on
       string filter: filter command
     Outgoing arguments:
       none
     Description:
       Sets filter command for the file */

  string getMultiFileFilter(string filename);
  /* Incoming arguments:
       string: filename to operate on
     Outgoing arguments:
       string: filter command
     Description:
       Gets filter command for the file */

  void setMultiFileFilterQuoteChar(string filename, string quote);
  /* Incoming arguments:
       string filename: filename to operate on
       string quote: quoting char
     Outgoing arguments:
       none
     Description:
       Sets quoting character for the file's filter cmd */

  string getMultiFileFilterQuoteChar(string filename);
  /* Incoming arguments:
       string filename: filename to operate on
     Outgoing arguments:
       string: quoting character
     Description:
       Gets quoting character for the file's filter cmd */

  string getMultiFileFirstFilename();
  /* Incoming arguments:
       none
     Outgoing arguments:
       string: filename for the first file
     Description:
       Returns filename for the first file in the multiple file list 
       Returns END if empty list */

  string getMultiFileFirstPlotCmd();
  /* Incoming arguments:
       none
     Outgoing arguments:
       string: command for plotting the first file in the list
     Description:
       Returns plotting command for the first file in the list */

  string getMultiFileNextFilename();
  /* Incoming arguments:
       none
     Outgoing arguments:
       string: filename for the next file
     Description:
       Returns filename for the next file in the multiple file list 
       Returns END if at the end of the list */

  string getMultiFileNextPlotCmd();
  /* Incoming arguments:
       none
     Outgoing arguments:
       string: command for plotting the next file in the list
     Description:
       Returns plotting command for the next file in the list 
       Each time this is called, it auto-increments to next element */

  void setLegendTitle(string file, string title);
  /* Incoming arguments:
       file: file to operate on
       title: title for legend
     Outgoing arguments:
       none
     Description:
       Sets title to be used in legend */

  string getLegendTitle(string file);
  /* Incoming arguments:
       file: file to operate on
     Outgoing arguments:
       string: title for current file
     Description:
       Gets title to be used in legend for the current file */

private:
  /* Implement a multiFileList with Qt's Dictionary data structure. 
     If you are porting to another GUI toolkit, re-implement this class */
  QDict<gnuPlotFile>* fileList;
  QDictIterator<gnuPlotFile>* fileListIterator;
  gnuPlotFile* tempFile;
};

