/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _ITEM_FACTORY_H_
#define _ITEM_FACTORY_H_

#include <qobject.h>
#include <qlistview.h>

class LogLine;
class ParentLogLine;
class ChildLogLine;
class LogListItem;

/**
 * @author Nicolas Ternisien
 */
class ItemFactory {

	public:
		static LogListItem* createLogListItem(QListView* view, LogLine* line);
		
		static QString createFormattedText(LogLine* line);
		static QString createToolTipText(LogLine* line);

		//Global useful methods
		static QString messageFormat(QString& message);
		static QString labelMessageFormat(QString label, QString value);
	
	private:
		static LogListItem* createItem(QListView* view, LogLine* line);
		
		static LogListItem* createParentItem(QListView* view, ParentLogLine* line);
		
		static LogListItem* createChildItem(QListView* view, ChildLogLine* line);
		
		static LogListItem* createBasicItem(QListView* view, LogLine* line);
		
		static void initXorgItem(LogListItem* item);
		static void initDefaultItem(LogListItem* item);
		
		static void initItem(LogListItem* item);
		
		
		
		
		
		
		static QString createXorgFormattedText(LogLine* line);
		static QString createCronFormattedText(LogLine* line);
		static QString createAcpidFormattedText(LogLine* line);
		static QString createCupsFormattedText(LogLine* line);
		static QString createCupsAccessFormattedText(LogLine* line);
		
		static QString createParentFormattedText(LogLine* line);
		
		static QString createDefaultFormattedText(LogLine* line);
		
		static QString createApacheFormattedText(LogLine* line);
		static QString createApacheAccessFormattedText(LogLine* line);
		static QString createSambaFormattedText(LogLine* line);
		
		static QString createXorgToolTipText(LogLine* line);
		
		static QString createDefaultToolTipText(LogLine* line);

		
};

#endif
