/***************************************************************************
 *   Copyright (C) 2005 by Will Entriken                                   *
 *   william.entriken@villanova.edu                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PROCESSCONTROLLER_H
#define PROCESSCONTROLLER_H

#include <qprocess.h>
#include <qstring.h>
#include <qtimer.h>
#include <qobject.h>

class ProcessListViewItem;

class ProcessController : public QObject
{
	Q_OBJECT
public:
	ProcessController(ProcessListViewItem * parent);
	~ProcessController();
	
	bool getStatus();
	void setUrl(QString Url);
	void setDescription(QString Description);
	QString getUrl();
	QString getDescription();
	void startRip(QString destination, QString time);
	void stopRip();

protected slots:
	void readStdout();
	
private:
	ProcessListViewItem * myParent;
	bool myStatus;
	
	QProcess * myProcess;
	QString myUrl;
	QString myDescription;
};

#endif
