/*
    KSocrat
    Version 3.1.2, 28 April 2003    
    (C) 2000-2003 Zavolzhsky Alexandr <zavolzhsky@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <kapp.h>
#include <klocale.h>
#include <qtooltip.h>
#include <kstddirs.h>
#include <qpixmap.h>
#include "ksocrat.h"

void  KSocrat::initDialog(){
  KStandardDirs *dataDir = new KStandardDirs();
  QString sClearImg = dataDir->findResource("data","ksocrat/clear.png");

  this->resize(310,315);
  this->setMinimumSize(310,315);
  
  QRect scr = QApplication::desktop()->screenGeometry();
  this->move(scr.center() - rect().center());
  
  bgTranslate= new QButtonGroup(this,"bgTranslate");
  bgTranslate->setGeometry(5,5,130,62);
  bgTranslate->setMinimumSize(0,0);
  bgTranslate->setTitle(i18n("Translate"));

  rbEnglish= new QRadioButton(bgTranslate,"rbEnglish");
  rbEnglish->setGeometry(10,15,105,20);
  rbEnglish->setMinimumSize(0,0);
  rbEnglish->setText(i18n("From &English"));
  rbEnglish->setChecked(true);

  rbRussian= new QRadioButton(bgTranslate,"rbRussian");
  rbRussian->setGeometry(10,35,105,20);
  rbRussian->setMinimumSize(0,0);
  rbRussian->setText(i18n("From &Russian"));

  edWord = new KComboBox(true,this,"edWord");
  edWord->setGeometry(142,12,160,22);
  edWord->setMinimumSize(0,0);
  edWord->setMaxCount(20);
  edWord->setInsertionPolicy(QComboBox::AtTop);
  edWord->setAutoCompletion(true);
  edWord->setDuplicatesEnabled(false);
  QToolTip::add(edWord,i18n("Enter word to translate here"));
  edWord->setFocus();

  btClear= new QPushButton(this,"btClear");
  btClear->setGeometry(140,46,24,18);
  btClear->setMinimumSize(0,0);
  btClear->setPixmap(QPixmap(sClearImg));
  QToolTip::add(btClear,i18n("Clear text and results (Alt + C)"));

  btTranslate= new QPushButton(this,"btTranslate");
  btTranslate->setGeometry(170,42,132,24);
  btTranslate->setMinimumSize(0,0);
  btTranslate->setText(i18n("&Translate"));

  cbAutoLanguage = new QCheckBox(this,"cbAutoLanguage");
  cbAutoLanguage->setGeometry(5,72,150,20);
  cbAutoLanguage->setMinimumSize(0,0);
  cbAutoLanguage->setChecked(true);
  cbAutoLanguage->setText(i18n("Auto-detect language"));

  cbKeepTrans = new QCheckBox(this,"cbKeepTrans");
  cbKeepTrans->setGeometry(160,72,150,20);
  cbKeepTrans->setMinimumSize(0,0);
  cbKeepTrans->setText(i18n("Append translation"));

  cbSentTrans =  new QCheckBox(this,"cbSentTrans");
  cbSentTrans->setGeometry(5,92,250,20);
  cbSentTrans->setMinimumSize(0,0);
  cbSentTrans->setChecked(false);
  cbSentTrans->setText(i18n("Try to translate phrase as the sentence"));
    
  meResult= new QMultiLineEdit(this,"meResult");
  meResult->setGeometry(5,115,300,160);
  meResult->setMinimumSize(0,0);

  btSave= new QPushButton(this,"btSave");
  btSave->setGeometry(5,283,60,24);
  btSave->setMinimumSize(0,0);
  btSave->setText(i18n("&Save"));

  btConfigure= new QPushButton(this,"btConfigure");
  btConfigure->setGeometry(70,283,60,24);
  btConfigure->setMinimumSize(0,0);
  btConfigure->setText(i18n("Setu&p"));

  btAbout= new QPushButton(this,"btAbout");
  btAbout->setGeometry(135,283,60,24);
  btAbout->setMinimumSize(0,0);
  btAbout->setText(i18n("&About"));

  btHide= new QPushButton(this,"btHide");
  btHide->setGeometry(200,283,50,24);
  btHide->setMinimumSize(0,0);
  btHide->setText(i18n("&Hide"));
  
  btExit= new QPushButton(this,"btExit");
  btExit->setGeometry(255,283,50,24);
  btExit->setMinimumSize(0,0);
  btExit->setText(i18n("E&xit"));
}
