/***************************************************************************
 *   Copyright (C) 2004-2008 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <dcopclient.h>
#include <qdatastream.h>
#include <qstring.h>

#include "version.h"

static const char description[] =
  I18N_NOOP("ksniffer_client - a DCOP client for KSniffer");

static KCmdLineOptions options[] =
{
  KCmdLineLastOption
};

int main(int argc, char *argv[])
{
  KAboutData aboutData( "ksniffer_client", I18N_NOOP("ksniffer_client"),
  APPVER, description, KAboutData::License_GPL, "(C) 2004-2008, Giovanni Venturi");
  aboutData.addAuthor( "Giovanni Venturi", 0, "giovanni@ksniffer.org" );
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options );

  KApplication app(false, false);

  // get our DCOP client and attach so that we may use it
  DCOPClient *client = app.dcopClient();
  client->attach();

  // do a 'send' for now
  QByteArray data;
  QDataStream ds(data, IO_WriteOnly);
  if (argc > 1)
    ds << QString(argv[1]);
  else
    ds << QString("http://www.kde.org/");
  client->send("ksniffer", "ksnifferIface", "openURL(QString)", data);

  return app.exec();
}
