/***************************************************************************
                          rampanel.cpp  -  description
                             -------------------
    begin                : Fri Jan 11 2002
    copyright            : (C) 2002 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rampanel.h"

#include "procinfo.h"

RamPanel::RamPanel(QWidget *parent, const char *name): BarMeterPanel(parent,name)
{
  setFooter(QString("RAM USED"));
  updateInfo();
}

RamPanel::~RamPanel(){
}


void RamPanel::updateInfo()
{
 int memTotal,memUsed,swapTotal,swapUsed;

 getMemInfo(&memTotal,&memUsed,&swapTotal,&swapUsed);

 QString str;
 str.sprintf ("%.0fM" , (double)memTotal  / 1024 );
 setHeader(str);

 str.sprintf ("%.0fM" , (double)memUsed  / 1024 );
 setString(str);

 setBarValue(memUsed,memTotal);

 update();
}


