/***************************************************************************
                          rampanel.cpp  -  description
                             -------------------
    begin                : Fri Jan 11 2002
    copyright            : (C) 2002 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cputimepanel.h"

#include "procinfo.h"

CpuTimePanel::CpuTimePanel(QWidget *parent, const char *name): Panel(parent,name)
{
 lcd1= new QLCDString(this);
 lcd1->setGeometry(17,37,46,8);
 lcd1->setForegroundColor(red);
 lcd1->setAlign(QLCDString::alignLeft);
 lcd1->setNumberDisplay(true);
 lcd1->installEventFilter(this);

 QColor color2( 200, 0, 0);

 lcd2= new QLCDString(this);
 lcd2->setGeometry(17,27,46,8);
 lcd2->setForegroundColor(color2);
 lcd2->setAlign(QLCDString::alignLeft);
 lcd2->setNumberDisplay(true);
 lcd2->installEventFilter(this);

 QColor color3( 128,32,0 );

 lcd3= new QLCDString(this);
 lcd3->setGeometry(17,17,46,8);
 lcd3->setForegroundColor(color3);
 lcd3->setAlign(QLCDString::alignLeft);
 lcd3->setNumberDisplay(true);
 lcd3->installEventFilter(this);

 lcd4= new QLCDString(this);
 lcd4->setGeometry(17,7,46,8);
 lcd4->setForegroundColor(darkGreen);
 lcd4->setAlign(QLCDString::alignLeft);
 lcd4->setNumberDisplay(true);
 lcd4->installEventFilter(this);

 barMeter= new QBarMeter(this);
 barMeter->move(6,6);
 barMeter->resize(6,52);
 barMeter->setDirection(QBarMeter::dirUp);
 barMeter->setSteps(13);
 barMeter->useValueMax(false);
 barMeter->setValueColor( 0, red );
 barMeter->setValueColor( 1, color2 );
 barMeter->setValueColor( 2, color3 );
 barMeter->setValueColor( 3, green );
 barMeter->setValueCount(4);
 barMeter->installEventFilter(this);

 getCpuTime(&old_user,&old_nice,&old_system,&old_idle);
 updateInfo();
}

CpuTimePanel::~CpuTimePanel(){
}


void CpuTimePanel::drawContents(QPainter *p)
{
 QLcd::draw(p, 16,50,46,8, "CPU STATE",QLcd::alignCenter,&black);
}



void CpuTimePanel::updateInfo()
{
 int user,nice,system,idle;

 getCpuTime(&user,&nice,&system,&idle);

 int puser  = user   - old_user;
 int pnice  = nice   - old_nice;
 int psystem= system - old_system;
 int pidle  = idle   - old_idle;

 int ptotal=  puser+pnice+psystem+pidle;

 if (ptotal==0) ptotal=1;

 QString str;
 str.sprintf ("USER%5.1f" , (float)puser  /ptotal * 100 );
 lcd1->display(str);
 str.sprintf ("NICE%5.1f" , (float)pnice  /ptotal * 100 );
 lcd2->display(str);
 str.sprintf ("SYS %5.1f" , (float)psystem/ptotal * 100 );
 lcd3->display(str);
 str.sprintf ("IDLE%5.1f" , (float)pidle  /ptotal * 100 );
 lcd4->display(str);

 barMeter->setValue(0,(double)puser);
 barMeter->setValue(1,(double)pnice);
 barMeter->setValue(2,(double)psystem);
 barMeter->setValue(3,(double)pidle);

 old_user  = user;
 old_nice  = nice;
 old_system= system;
 old_idle  = idle;
}
