/***************************************************************************
                          wizard.cpp  -  description
                             -------------------
    begin                : Die Mai 15 15:34:19 CEST 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Own includes
#include "wizard.h"
#include "krenameimpl.h"

// KDE includes
#include <kapplication.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kmessagebox.h>
#include <kstartupinfo.h>

// Qt includes
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qsizepolicy.h>
#include <qvbox.h>

wizard::wizard( KRenameImpl* impl, QRect r, QWidget* parent,  const char* name )
    : KWizard( parent, name )
{
    setIcon( BarIcon( "krename" ) );
    menuBar = new KMenuBar(this);

    if( impl ) {
        krename = impl;
        connect( krename, SIGNAL( pageDone( QWidget*, const QString & ) ), this, SLOT( slotAddPage( QWidget*, const QString & ) ) );
        krename->changeParent( this, menuBar, this->finishButton(), r );
    } else {
        krename = new KRenameImpl( this, menuBar, this->finishButton() );
        connect( krename, SIGNAL( pageDone( QWidget*, const QString & ) ), this, SLOT( slotAddPage( QWidget*, const QString & ) ) );
    }
    
    connect( krename, SIGNAL( showPage( int ) ), this, SLOT( slotShowPage( int ) ) );
    connect( krename, SIGNAL( enableFinish( bool ) ), this, SLOT( slotEnableFinish( bool ) ) );
    if( !impl )
        krename->setup();
    
    krename->setWizardMode( true );
    
    // Tell KStartupInfo that KRename has been loaded completly
    KStartupInfoId id;
    id.initId( kapp->startupId() );
    KStartupInfo::sendFinish( id );
    
    // Disable ESC key
    cancelButton()->setAccel( QKeySequence() );
}

wizard::~wizard()
{
}

void wizard::slotAddPage( QWidget* page, const QString & title )
{
    // exclude page 3 from wizard
    if( krename->title( 2 ) == title )
    {
        page->hide();
        return;
    }

    QString t = title + i18n(" - Step %1 of %2").arg( pageCount()+1 ).arg( 3 );
        
    QVBox* layout = new QVBox( this );
   
    new QLabel( QString( t ).remove( title.find( "&" ), 1 ), layout );

    QFrame* hbar1 = new QFrame( layout, "<hr>", 0 );
    hbar1->setFrameStyle( QFrame::Sunken + QFrame::HLine );

    page->reparent( layout, QPoint( 0, 0 ) );
    addPage( layout, t );
    setHelpEnabled( layout, false );
}

void wizard::slotShowPage( int page )
{
    showPage( this->page( page - 1 ) );
}

void wizard::slotEnableFinish( bool b )
{
    setFinishEnabled( page( pageCount() - 1), b );
}

void wizard::accept()
{
/** do nothing */
}

