
#if sun

#define LITTLE_ENDIAN	1234
#define BIG_ENDIAN	4321
#define PDP_ENDIAN	3412

#include <sys/isa_defs.h>

#if defined(_LITTLE_ENDIAN)
#define BYTE_ORDER	LITTLE_ENDIAN
#elif defined(_BIG_ENDIAN)
#define BYTE_ORDER	BIG_ENDIAN
#endif

#else

/* linux */
#include <endian.h>

#endif


/* ---------------------------------------------------------------------- */

#if BYTE_ORDER == LITTLE_ENDIAN

# define cpu_to_le32(x) (x)
# define cpu_to_le16(x) (x)
# define le32_to_cpu(x) (x)
# define le16_to_cpu(x) (x)

#elif BYTE_ORDER == BIG_ENDIAN

# define cpu_to_le32(x) (\
	((x & 0x000000FF) << 24) | \
	((x & 0x0000FF00) << 8) | \
	((x & 0x00FF0000) >> 8) | \
	((x & 0xFF000000) >> 24))
# define le32_to_cpu(x) cpu_to_le32(x)

# define cpu_to_le16(x) (((x & 0x00FF) << 8) | (x >> 8))
# define le16_to_cpu(x) cpu_to_le16(x)

#else

# error Unknow byte order type

#endif
