//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGCONNECTIONINTHREAD_H
#define KPGCONNECTIONINTHREAD_H

// include files for Qt
#include <qstringlist.h>
#include <qthread.h>
#include <qevent.h>

#include "DbObjects/kpgconnection.h"

/**
Event, that contain SQL operation result

@author Lumir Vanek
*/

class KPGQueryResultEvent : public QCustomEvent
{
public:
    KPGQueryResultEvent(KPGConnection * pConnection)
      : QCustomEvent( 65432 )
    {
        m_pConnection = pConnection;
        m_iExecutionMiliseconds = 0;
    }
     
    void setError(const QString & strError) { m_strError = strError; }
    const QString & error() const { return m_strError; }
    KPGConnection * connection() { return m_pConnection; }
    
    void setExecutionMiliseconds(int iExecutionMiliseconds) { m_iExecutionMiliseconds = iExecutionMiliseconds; }
    int executionMiliseconds() const { return m_iExecutionMiliseconds; }

private:
    QString m_strError;
    KPGConnection *m_pConnection;
    int m_iExecutionMiliseconds;
};

/**
Thread, that run connection to PostgreSQL server

@author Lumir Vanek
*/

class KPGConnectionInThread : public QThread
{
public:
    KPGConnectionInThread();
    ~KPGConnectionInThread();
    
    // Types of operation, that this class can do 
	enum eOperationType { eRunSql, eRunPreparedStatement };
    
    // Set type of operation
    void setOperationType(eOperationType operationType) { m_OperationType = operationType; }
    
    // Try connect to PostgreSQL server by given connection strong. Throw exception, if fails
    void connectToServer(const QString &);
    
    // Close connection
    void disconnectFromServer();
    
    // Call it when connection thread is terminated
    void leaveConnection();
    
    // Return connection
    KPGConnection * connection() const { return m_pConnection; }

    void setSQL(const QString &strSQL, KPGConnection::ETransType eTransType) 
    { 
    	m_strSQL = strSQL; 
    	m_eTransType = eTransType; 
    }
    
    // Set name of prepared statement
    void setPrepStatementName(const std::string &stdstrPrepStmtName, KPGConnection::ETransType eTransType)
    { 
    	m_stdstrPrepStmtName = stdstrPrepStmtName; 
    	m_eTransType = eTransType;
    } 
    
    // Get name of prepared statement
    const std::string & prepStatementName() const { return m_stdstrPrepStmtName; }
    
    // Set arguments for prepared statement
    void setPrepStatementArgumentValues(const ListArgumentsWithValues & listArgumentsWithValues)
    { 
    	m_listArgumentsWithValues = listArgumentsWithValues;
    } 
    
    // Receiver of event, it contain pqxx::result that is set when event fired
    void setEventReceiver(QObject * pEventReceiver, pqxx::result *pPqxxResult) 
    { 
    	m_pEventReceiver = pEventReceiver; 
    	m_pPqxxResult = pPqxxResult;
    }
        
protected:
    virtual void run();
    
protected:
	eOperationType m_OperationType;
	KPGConnection *m_pConnection;
	pqxx::result *m_pPqxxResult;
	
	QString m_strSQL; // SQL that is used for perform action
	
	ListArgumentsWithValues m_listArgumentsWithValues;
	std::string m_stdstrPrepStmtName; // Name of prepared statement to execute
	
	KPGConnection::ETransType m_eTransType;
	QObject *m_pEventReceiver; // event receiver
};

#endif
