/***************************************************************************
                          kpgconnectdialog.cpp  -  description
                             -------------------
    begin                : So led 10 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpgconnectdialog.h"

#include <qpushbutton.h>
#include <klineedit.h>

KPGConnectDialog::KPGConnectDialog(QWidget *parent, const char *name )
  : KPGConnectDialogBase(parent, name)
{
 	connect( m_pLineEditHostName, SIGNAL(textChanged(const QString&)), this, SLOT(slotContextChanged(const QString&)) );
	connect( m_pLineEditUserName, SIGNAL(textChanged(const QString&)), this, SLOT(slotContextChanged(const QString&)) );
	connect( m_pLineEditPassword, SIGNAL(textChanged(const QString&)), this, SLOT(slotContextChanged(const QString&)) );
}

KPGConnectDialog::~KPGConnectDialog()
{
}

void KPGConnectDialog::toggleAcceptButton()
{
  if ( m_pLineEditHostName->text().isEmpty() ||
       m_pLineEditUserName->text().isEmpty() ||
       //m_pLineEditPassword->text().isEmpty() ||
       m_pLineEditPort->text().isEmpty()
     )
    m_pButtonOk->setEnabled(false);
  else
    m_pButtonOk->setEnabled(true);
}

void KPGConnectDialog::slotContextChanged( const QString & /*strText*/ )
{
  toggleAcceptButton();
}

void KPGConnectDialog::accept()
{
  m_strHostName = m_pLineEditHostName->text();
  m_strPortNumber = m_pLineEditPort->text();
  m_strDatabaseName = m_pLineEditDatabase->text();
  m_strUserName = m_pLineEditUserName->text();
  m_strPassword = m_pLineEditPassword->text();
  
  
  KPGConnectDialogBase::accept();
}

void KPGConnectDialog::setGui()
{
  m_pLineEditHostName->setText(m_strHostName);
  m_pLineEditPort->setText(m_strPortNumber);
  m_pLineEditUserName->setText(m_strUserName);
  m_pLineEditDatabase->setText(m_strDatabaseName);
  m_pLineEditPassword->setFocus();
}
