/***************************************************************************
                          kpgbookmarkhandler.cpp  -  description
                             -------------------
    begin                : Ne led 25 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpgbookmarkhandler.h"

#include <qstring.h>

#include <kbookmarkimporter.h>
#include <kpopupmenu.h>
#include <ksavefile.h>
#include <kstandarddirs.h>
#include <kdiroperator.h>
#include <kaction.h>
#include <kmessagebox.h>
#include <kdebug.h>

#include "kpgbookmarkmenu.h"

KPGBookmarkHandler::KPGBookmarkHandler( QWidget* parent, KPopupMenu* kpopupmenu )
    : QObject( parent ),
      KBookmarkOwner(),
      mParent( parent )
{
  KPopupMenu *menu = kpopupmenu;

  if (!menu)
    menu = new KPopupMenu( parent, "bookmark menu" );
    
  // Let's find our bookmark file
  QString file = locate( "data", "kpogre/servers.xml" );
  if ( file.isEmpty() )
  {
    file = locateLocal( "data", "kpogre/servers.xml" );
  }

  KBookmarkManager *manager = KBookmarkManager::managerForFile( file, false);
  manager->setUpdate( true );
  manager->setShowNSBookmarks( false );

  m_pBookmarkMenu = new KPGBookmarkMenu( manager, this, menu, 0, true );

  m_strNewBookmarkName = "";
  m_strNewBookmarkUrl = "";
}

KPGBookmarkHandler::~KPGBookmarkHandler()
{
}

void KPGBookmarkHandler::openBookmarkURL(const QString& url)
{
  kdDebug() << "Opening url: " << url << endl;
  emit openUrl( url );
}


QString KPGBookmarkHandler::currentURL() const
{
    return m_strNewBookmarkUrl;
}

QString KPGBookmarkHandler::currentTitle() const
{
  return m_strNewBookmarkName;
}

void KPGBookmarkHandler::enableAddBookmarkMenu(bool bEnable)
{
   m_pBookmarkMenu->enableAddBookmarkMenu(bEnable);
}


