//
// C++ Implementation: kpgcreaterulewizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreaterulewizard.h"

// include files for Qt
#include <qcheckbox.h>
#include <qframe.h> 
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlistview.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <klistbox.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "kpgcreaterulewidget1.h"


KPGCreateRuleWizard::KPGCreateRuleWizard(QWidget *parent, const char *name, const QString& strSchemaName, const QString& strTableName)
 : KPG3StepsWizard(parent, name)
{
	KPGCreateRuleWidget1 *pCreateRuleWidget1 = new KPGCreateRuleWidget1(WizardPage1, "KPGCreateRuleWidget1", strSchemaName, strTableName);
	m_pPageWidget1 = pCreateRuleWidget1;
	WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
	connect(pCreateRuleWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
	
	languageChange();
}

KPGCreateRuleWizard::~KPGCreateRuleWizard()
{
}

void KPGCreateRuleWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
    
    setCaption( i18n( "Add Rule to Table" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Rule name and properties" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateRuleWizard::showPage(QWidget *pPage)
{
  if(pPage == WizardPage2) // Step 2 - Review SQL statement
  {
    KPGCreateRuleWidget1 *pCreateRuleWidget1 = static_cast <KPGCreateRuleWidget1 *> (m_pPageWidget1);
    m_pTextEditSQL->setText(pCreateRuleWidget1->getSQL());
  }
  
  if(pPage == WizardPage3) // Step 3 - Check operation result
  {
    runQuery();
  }

  // call parent
  KPG3StepsWizard::showPage(pPage);
}


#include "kpgcreaterulewizard.moc"
