//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatedomainwizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgdatabase.h"
#include "kpgcreatedomainwidget1.h"
#include "kpgcreatedomainwidget2.h"
#include "kpgcreatedomainwidget3.h"


KPGCreateDomainWizard::KPGCreateDomainWizard(QWidget *parent, const char *name, KPGDatabase *pDatabase, QPtrList<QListViewItem> &listOfSchemas)
 : KPG5StepsWizard(parent, name)
{
  KPGCreateDomainWidget1 *pCreateDomainWidget1 = new KPGCreateDomainWidget1(WizardPage1, "KPGCreateDomainWidget1", listOfSchemas);
  m_pPageWidget1 = pCreateDomainWidget1;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pCreateDomainWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
  
  KPGCreateDomainWidget2 *pCreateDomainWidget2 = new KPGCreateDomainWidget2(WizardPage2, "KPGCreateDomainWidget2", pDatabase);
  m_pPageWidget2 = pCreateDomainWidget2;
  WizardPage2Layout->addWidget(m_pPageWidget2, 0, 0);
  
  KPGCreateDomainWidget3 *pCreateDomainWidget3 = new KPGCreateDomainWidget3(WizardPage3, "KPGCreateDomainWidget3");
  m_pPageWidget3 = pCreateDomainWidget3;
  WizardPage3Layout->addWidget(m_pPageWidget3, 0, 0);
         
  languageChange();
  
  setNextEnabled(WizardPage2, true);
}

KPGCreateDomainWizard::~KPGCreateDomainWizard()
{
}

void KPGCreateDomainWizard::languageChange()
{
    KPG5StepsWizard::languageChange();
    
    setCaption( i18n( "Create new domain" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Domain name" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Domain properties" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Domain constraints" ) );
    setTitle( WizardPage4, i18n( "Step 4 - Review SQL statement" ) );
    setTitle( WizardPage5, i18n( "Step 5 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateDomainWizard::showPage(QWidget *pPage)
{   
  if(pPage == WizardPage3) // Step 3 - Review SQL statement
  {
    // prepare SQL statement
    QString strSQL;
    strSQL.append((static_cast <KPGCreateDomainWidget1 *> (m_pPageWidget1))->getSQL());
    strSQL.append((static_cast <KPGCreateDomainWidget2 *> (m_pPageWidget2))->getSQL());
    strSQL.append((static_cast <KPGCreateDomainWidget3 *> (m_pPageWidget3))->getSQL());
    strSQL.append(";\n");
        
    m_pTextEditSQL->setText(strSQL);
  }
  
  if(pPage == WizardPage5) // Step 5 - Check operation result
  {
    runQuery();
  }
  
  // call parent
  KPG5StepsWizard::showPage(pPage);
}


#include "kpgcreatedomainwizard.moc"
