//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcopytablewidget3.h"

// include files for KDE
#include <kactionselector.h> 

// application specific includes
#include "../DbObjects/kpgtablecolumnsfolder.h"
#include "../kpgutil.h"


KPGCopyTableWidget3::KPGCopyTableWidget3(QWidget *parent, const char *name, KPGTable *pTable)
 : KPGCopyTableWidget3Base(parent, name)
{
  pTable->getTableColumnsFolder()->fillListBoxWithChildItems(m_pColumnsSelector->availableListBox(), false);
}

KPGCopyTableWidget3::~KPGCopyTableWidget3()
{
}

void KPGCopyTableWidget3::setCvsMode(bool bCvsMode)
{
  m_bCvsMode = bCvsMode;
  m_pColumnsSelector->setEnabled(bCvsMode);
    
  emit sigEnableNextButton(true);
}

const QString KPGCopyTableWidget3::getSQL() const
{
  if(!m_bCvsMode) return "";
  
  QString strSQL("");
 
  if(m_pColumnsSelector->selectedListBox()->count() > 0)
  {
    for(unsigned int i = 0; i < m_pColumnsSelector->selectedListBox()->count(); i++)
    {
      strSQL.append(KPGUtil::quotedName(m_pColumnsSelector->selectedListBox()->text(i)));
      
      if(i < m_pColumnsSelector->selectedListBox()->count() - 1)
        strSQL.append(", ");
    }
  }
  
  return strSQL;
}


#include "kpgcopytablewidget3.moc"
