//
// C++ Interface: kpguserproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGUSERPROPPAGE_H
#define KPGUSERPROPPAGE_H

#include "kpguserproppagebase.h"

// application specific includes
#include "kpgabstractpropertypage.h"

// include files for libpgxx 
#include <pqxx/util> 

class KPGUser;

/**
  * User properties
  *
  * @author Lumir Vanek
  */
class KPGUserPropPage : public KPGUserPropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGUserPropPage(QWidget *parent, KPGUser *);
    ~KPGUserPropPage();
    
    // Display properties of underlying database object
	virtual void displayProperties();

	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	
protected:

	KPGUser * m_pUser;
	
protected slots:
            
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);    
		
signals:
  	void sigSearchObject(const pqxx::oid);   
   	            
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
