/***************************************************************************
                          korinoco_kcmodule.h  -  description
                             -------------------
    begin                : Die Okt  2 19:41:16 CEST 2001
    copyright            : (C) 2001 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KORINOCO_KCMODULE_H_
#define KORINOCO_KCMODULE_H_

#include <kcmodule.h>
#include <kaboutdata.h>

#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>

#define DONT_LOAD_ARTS

#include "../korinoco/stuff.h"
#include "../korinoco/stuff.cpp"

enum speedlevels { AUTO, M1, M2, M55, M11 };
enum packetmode { UNI, MULTI, BOTH };
enum cryptomodes { OPEN, RESTRICTED };

struct configuration_data {
	QString net_name[5];
	QString disp_name[5];
	bool managed[5];
	bool crypto_enabled[5];
	int active_crypto_key[5];
	QString active_key_string[5];
	QString crypto1[5],crypto2[5],crypto3[5],crypto4[5];
	bool crypto_is_string1[5], crypto_is_string2[5],crypto_is_string3[5], crypto_is_string4[5];
	cryptomodes crypto_mode[5];
	bool pm_enabled[5];
	int sleep_time[5];
	QString sleep_time_string[5];
	int wake_time[5];
	QString wake_time_string[5];
	speedlevels bitrate[5];
	packetmode packet[5];
};

int set_info(int		skfd, const char * args[], int	count,	 const char *		ifname);

class KOrinoco_ConfigWidget2 : public QWidget {
 	Q_OBJECT
	public:
	KOrinoco_ConfigWidget2(QWidget* parent, const char* name=0L);
	void saveData();
	QPushButton* actButton;
	public slots:
	void slotAutodetectInterface();
	void slotUserChangedSomething();
  void slotActivateNow();
	signals:
	void changed();
	private:
	QComboBox* config_to_activate;
	QLabel* myLabel, *myNextLabel;
	QCheckBox* activate;
	QLineEdit* interfaceselector;
	QPushButton* autodetect;
	
};

class KOrinoco_ConfigWidget : public QWidget {
	Q_OBJECT
	public:
	KOrinoco_ConfigWidget(int number, QWidget* parent, const char* name=0L);
	void saveData(int which_one);
	public slots:
		void slotUserChangedSomething();
		void slotTogglePower(bool aktiv);
		void slotToggleCrypto(bool aktiv);
	signals:
		void changed();
	private:
		QGridLayout* geo;
		QLineEdit* display_name, *network_name, *crypto1, *crypto2, *crypto3, *crypto4, *sleeptime, *waketime, *crypto_number;
		QButtonGroup* mangroup, *bitrate, *receive, *openquery;
		QRadioButton* managed, *ad_hoc, *MXA, *MX1, *MX2, *MX55, *MX11, *rec_uni, *rec_multi, *rec_both, *open, *rest;
		QGroupBox* cryptobox;
		QCheckBox* ct1, *ct2, *ct3, *ct4, *pm, *use_crypto;
		QLabel *sleep, *wake, *cryptlabel;
};

void iw_usage(void);

class KOrinoco_KCModule: public KCModule
{
   Q_OBJECT
   public:
      KOrinoco_KCModule(QWidget *parent = 0L, const char *name = 0L);
      virtual ~KOrinoco_KCModule();
	  static configuration_data* configs;
	  static bool use_preset_config;
	  static int preset_config_to_use;
	  static QString interface_to_use;
	  static void init();
	  static void changeConfig(int x, int skfd, QString interface);
      void load();
      void save();
      void defaults();
      int buttons();
      QString quickHelp() const;
      const KAboutData* aboutData() {return myAboutData; };

   public slots:
      void configChanged();

   private:
	    KAboutData *myAboutData;
		KOrinoco_ConfigWidget* config1;
		KOrinoco_ConfigWidget* config2;
		KOrinoco_ConfigWidget* config3;
		KOrinoco_ConfigWidget* config4;
		KOrinoco_ConfigWidget2* config_gen;
		QTabWidget* configwindow;
};

#endif
