#include <klocale.h>
#include <kprocess.h>
#include <kstddirs.h>
#include <kmessagebox.h>
#include "myview.h"

#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qpixmap.h>
#include <qpainter.h>

int iw_getstats (const char *	ifname,  iwstats *	stats)
{
  FILE *	f=fopen("/proc/net/wireless","r");
  char		buf[256];
  char *	bp;
  int		t;
  if(f==NULL)
    return -1;
  /* Loop on all devices */
  while(fgets(buf,255,f))
    {
      bp=buf;
      while(*bp&&isspace(*bp))
	bp++;
      /* Is it the good device ? */
      if(strncmp(bp,ifname,strlen(ifname))==0 && bp[strlen(ifname)]==':')
  	{
	  /* Skip ethX: */
	  bp=strchr(bp,':');
	  bp++;
	  /* -- status -- */
	  bp = strtok(bp, " ");
	  sscanf(bp, "%X", &t);
	  stats->status = (unsigned short) t;
	  /* -- link quality -- */
	  bp = strtok(NULL, " ");
	  if(strchr(bp,'.') != NULL)
	    stats->qual.updated |= 1;
	  sscanf(bp, "%d", &t);
	  stats->qual.qual = (unsigned char) t;
	  /* -- signal level -- */
	  bp = strtok(NULL, " ");
	  if(strchr(bp,'.') != NULL)
	    stats->qual.updated |= 2;
	  sscanf(bp, "%d", &t);
	  stats->qual.level = (unsigned char) t;
	  /* -- noise level -- */
	  bp = strtok(NULL, " ");
	  if(strchr(bp,'.') != NULL)
	    stats->qual.updated += 4;
	  sscanf(bp, "%d", &t);
	  stats->qual.noise = (unsigned char) t;
	  /* -- discarded packets -- */
	  bp = strtok(NULL, " ");
	  sscanf(bp, "%d", &stats->discard.nwid);
	  bp = strtok(NULL, " ");
	  sscanf(bp, "%d", &stats->discard.code);
	  bp = strtok(NULL, " ");
	  sscanf(bp, "%d", &stats->discard.misc);
	  fclose(f);
	  return 0;
  	}
    }
  fclose(f);
  return -1;
}

int get_info (int skfd, const char * ifname, struct wireless_info *info)
{
  struct iwreq		wrq;

  memset((char *) info, 0, sizeof(struct wireless_info));

  /* Get frequency / channel */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  if(ioctl(skfd, SIOCGIWFREQ, &wrq) >= 0)
    {
      info->has_freq = 1;
    }

  /* Get operation mode */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  if(ioctl(skfd, SIOCGIWMODE, &wrq) >= 0)
    {
      if(wrq.u.mode < 6)
	info->has_mode = 1;
      info->mode = wrq.u.mode;
    }

};

myview::myview( int socketnumber, QWidget* parent,  const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{
    if ( !name )
	setName( "KOrinoco Kicker Applet" );
    resize( 178, 48 );
	socket = socketnumber;
  KStandardDirs finder;
  kdedir=finder.findResourceDir("data","korinoco/pics/no_card.png");
  kdedir+="korinoco/pics/";
    setMaximumSize( QSize( 32767, 48 ) );
    setMinimumSize( QSize( 16,16 ) );
    setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, sizePolicy().hasHeightForWidth() ) );
    setCaption( i18n( "Status Bar" ) );
	infocontainer = new wireless_info;
	infocontainer2 = new iwstats;
}

void myview::paintEvent (QPaintEvent *) {
    if (get_info(socket, "eth0", infocontainer)!=-1) { iw_getstats("eth0", infocontainer2); } else
    if (get_info(socket, "eth1", infocontainer)!=-1) { iw_getstats("eth1", infocontainer2); } else
    if (get_info(socket, "eth2", infocontainer)!=-1) { iw_getstats("eth2", infocontainer2); } else
    if (get_info(socket, "eth3", infocontainer)!=-1) { iw_getstats("eth3", infocontainer2); };
	QPainter* strengthpainter = new QPainter(this);
	if (infocontainer->has_freq==0) {pic = new QPixmap(kdedir+"offline.png");} else
	if (infocontainer->mode==1) { pic = new QPixmap(kdedir+"offline.png");} else
  if (infocontainer2->qual.qual>25) {pic = new QPixmap(kdedir+"excellent.png");} else
  if (infocontainer2->qual.qual>15) {pic = new QPixmap(kdedir+"good.png");} else
  if (infocontainer2->qual.qual>5) {pic = new QPixmap(kdedir+"marginal.png");} else
  if (infocontainer2->qual.qual>0) {pic = new QPixmap(kdedir+"oor_minimum.png");} else
  if ((infocontainer2->qual.qual==0)&&(infocontainer->mode==2)) {pic = new QPixmap(kdedir+"oor_down.png");} else
	 { pic = new QPixmap(kdedir+"offline.png");
	 };
	QString sstrength2="%1";
  if (infocontainer->has_freq==1) {
		if (infocontainer->mode==2) { sstrength2 = sstrength2.arg(infocontainer2->qual.qual);}
		else sstrength2 = sstrength2.arg(i18n("N/A"));
	} else sstrength2 = sstrength2.arg(i18n("N/A"));
	strengthpainter->drawText(0,38,sstrength2);

	strengthpainter->drawPixmap(0,0,*pic);
	delete pic;
	delete strengthpainter;
}

void myview::mousePressEvent(QMouseEvent *) {
	KProcess launch;
	launch << "korinoco";
	launch.start(KProcess::DontCare);
}

/*
 *  Destroys the object and frees any allocated resources
 */
myview::~myview()
{
    // no need to delete child widgets, Qt does it all for us
}

#include "myview.moc"
