
#include <kore/version.h>
#include <kore/servicemanager.h>

#define SM_MAJOR 0
#define SM_MINOR 0
#define SM_REVISION 1
#define SM_VERSION "0.0.1"
#define SM_API_MAJOR 0
#define SM_API_MINOR 0
#define SM_API_REVISION 1
#define SM_API_VERSION "0.0.1"
#define SM_NAME "Service Manager"
#define SM_TYPE "Service Manager"
#define SM_DESCRIPTION "Default Kore Service Manager"
#define SM_SERVICE "Kore/Kernel/Service Manager"
#define SM_SERVICE_DESCRIPTION "Kore Service Manager"

using namespace kore;

ServiceManager::ServiceManager()
{
    _smVersion = new Version(SM_MAJOR,SM_MINOR,SM_REVISION,SM_VERSION);
    _smAPIVersion = new Version(SM_API_MAJOR,SM_API_MINOR,SM_API_REVISION,SM_API_VERSION);
    _smInfo = new Info(this, SM_NAME, SM_TYPE, SM_DESCRIPTION, _smVersion, _smAPIVersion);
    setInfo(_smInfo);
    _smService = new Service(this, SM_SERVICE, SM_SERVICE_DESCRIPTION);
    addService(_smService);
}
ServiceManager::~ServiceManager()
{
    unregisterServices();
    unregisterProviders();
    delete _smInfo;
    delete _smVersion;
    delete _smAPIVersion;
    delete _smService;
}

void ServiceManager::registerService(const ServiceProvider::Service* srv)
{
    if( !srv->provider() )
        return;
    srv->provider()->registeringService(this, srv);
    _services.insert(srv_hash_type::value_type(srv->name(),srv));
    srv->provider()->serviceRegistered(this, srv);
}

void ServiceManager::unregisterService(const ServiceProvider::Service* srv)
{
    pair<srv_hash_type::iterator, srv_hash_type::iterator> p = _services.equal_range(srv->name());
    vector<srv_hash_type::iterator> rm;
    for( srv_hash_type::iterator i = p.first; i != p.second; ++i )
        if( i->second == srv )
            rm.push_back(i);
    int n = rm.size();
    for(int j = 0; j<n; j++)
    {
        srv->provider()->unregisteringService(this, srv);
        _services.erase(rm[j]);
        srv->provider()->serviceUnregistered(this, srv);
    }
}

void ServiceManager::registerProvider(ServiceProvider *provider)
{
    provider->registeringProvider(this);
    const Service** srvs = provider->services();
    for(int i=0; srvs[i]; i++)
        registerService(srvs[i]);
    delete[] srvs;
    provider->providerRegistered(this);
}

void ServiceManager::unregisterProvider(ServiceProvider *provider)
{
    provider->unregisteringProvider(this);
    const Service** srvs = provider->services();
    for(int i=0; srvs[i]; i++)
        unregisterService(srvs[i]);
    delete[] srvs;
    provider->providerUnregistered(this);
}

const ServiceProvider::Service** ServiceManager::registeredServices() const
{
    int n = _services.size();
    const Service** srvs = new const Service*[n+1];
    srv_hash_type::const_iterator b,e;
    b = _services.begin();
    e = _services.end();
    int i = 0;
    for( srv_hash_type::const_iterator j = b; j != e; ++j, ++i )
        srvs[i] = j->second;
    srvs[i] = 0;
    return srvs;
}

const ServiceProvider::Service** ServiceManager::registeredServices(ServiceProvider* prov) const
{
    vector<const Service*> srvs;
    srv_hash_type::const_iterator b,e;
    b = _services.begin();
    e = _services.end();
    for( srv_hash_type::const_iterator j = b; j != e; ++j )
        if( j->second->provider() == prov )
            srvs.push_back( j->second );
    int n = srvs.size();
    const Service** res = new const Service*[n+1];
    int i;
    for( i= 0; i < n; i++ )
        res[i] = srvs[i];
    res[i] = 0;
    return res;
}

const ServiceProvider::Service** ServiceManager::registeredServices(const Service* service) const
{
    return registeredServices(service->name());
}

const ServiceProvider::Service** ServiceManager::registeredServices(const char* service) const
{
    int n = _services.count(service);
    const Service** srvs = new const Service*[n+1];
    pair<srv_hash_type::const_iterator, srv_hash_type::const_iterator> p = _services.equal_range(service);
    int i = 0;
    for( srv_hash_type::const_iterator j = p.first; j != p.second; ++j, ++i )
        srvs[i] = j->second;
    srvs[i] = 0;
    return srvs;
}

const ServiceProvider::Service* ServiceManager::registeredService(const Service* service) const
{
    return registeredService(service->name());
}

const ServiceProvider::Service* ServiceManager::registeredService(const char* service) const
{
    pair<srv_hash_type::const_iterator, srv_hash_type::const_iterator> p = _services.equal_range(service);
    for( srv_hash_type::const_iterator j = p.first; j != p.second; ++j)
        return j->second;
    return 0;
}

ServiceProvider* ServiceManager::registeredProvider(const Service* service) const
{
    return registeredProvider(service->name());
}

ServiceProvider* ServiceManager::registeredProvider(const char* service) const
{
    const Service* srv = registeredService(service);
    if( srv )
        return srv->provider();
    else
        return 0;
}

ServiceProvider** ServiceManager::registeredProviders(const Service* service) const
{
    return registeredProviders(service->name());
}

ServiceProvider** ServiceManager::registeredProviders(const char* service) const
{
    sp_set_type sps;
    const Service** srvs = registeredServices(service);
	int i = 0;
    for(i = 0; srvs[i]; i++)
        sps.insert(srvs[i]->provider());
    delete[] srvs;
    int n = sps.size();
    ServiceProvider** res = new ServiceProvider*[n+1];
    i = 0;
    sp_set_type::const_iterator b,e;
    b = sps.begin();
    e = sps.end();
    for( sp_set_type::const_iterator j = b; j != e; ++j, ++i )
        res[i] = *j;
    res[i] = 0;
    return res;
}

ServiceProvider** ServiceManager::registeredProviders() const
{
    sp_set_type sps;
    const Service** srvs = registeredServices();
	int i = 0;
    for(i = 0; srvs[i]; i++)
        sps.insert(srvs[i]->provider());
    delete[] srvs;
    int n = sps.size();
    ServiceProvider** res = new ServiceProvider*[n+1];
    i = 0;
    sp_set_type::const_iterator b,e;
    b = sps.begin();
    e = sps.end();
    for( sp_set_type::const_iterator j = b; j != e; ++j, ++i )
        res[i] = *j;
    res[i] = 0;
    return res;
}

void ServiceManager::registerServices(const Service** srvs)
{
    for( int i = 0; srvs[i]; i++ )
        registerService(srvs[i]);
}
void ServiceManager::unregisterServices()
{
    const Service** srvs = registeredServices();
    for(int i = 0; srvs[i]; i++)
        unregisterService(srvs[i]);
    delete[] srvs;
}

void ServiceManager::registerProviders(ServiceProvider** providers)
{
    for( int i = 0; providers[i]; i++ )
        registerProvider(providers[i]);
}
void ServiceManager::unregisterProviders()
{
    ServiceProvider** srvs = registeredProviders();
    for(int i = 0; srvs[i]; i++)
        unregisterProvider(srvs[i]);
    delete[] srvs;
}
