
#include <qlistview.h>
#include <qlabel.h>
#include <qlistview.h>
#include <qstring.h>

#include <kore/version.h>

#include "moduleview_impl.h"

#define MV_MAJOR 0
#define MV_MINOR 0
#define MV_REVISION 1
#define MV_VERSION "0.0.1"
#define MV_API_MAJOR 0
#define MV_API_MINOR 0
#define MV_API_REVISION 2
#define MV_API_VERSION "0.0.2"
#define MV_NAME "Module View"
#define MV_TYPE MODULEVIEW_TYPE
#define MV_DESCRIPTION "Implementation for ModuleView"
#define MV_SERVICE MODULEVIEW_SERVICE
#define MV_SERVICE_DESCRIPTION "'" MODULEVIEW_SERVICE "' service"

using namespace kore;

/*
 *  Constructs a ModuleViewImpl which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
ModuleViewImpl::ModuleViewImpl( Module* mod, QWidget* parent,  const char* name, bool modal, WFlags fl )
    : ModulePropertiesDlg( parent, name, modal, fl )
{
    _module = mod;
    // disable sorting
    modulePropertiesView->setSorting(-1);
    const Module::Info* nfo = mod->info();
    setCaption( caption()+": "+nfo->name());
    descriptionLabel->setText( nfo->description() );
    // Module
    QListViewItem* item = modulePropertiesView->firstChild();
    QString addr;
    addr.sprintf("0x%08x", mod);
    item->setText(1, addr);
    // Info
    item = item->firstChild();
    addr.sprintf("0x%08x", nfo);
    item->setText(1, addr);
    // Name
    item = item->firstChild();
    item->setText(1, nfo->name() );
    // Type
    item = item->nextSibling();
    item->setText(1, nfo->type() );
    // Version
    item = item->nextSibling();
    item->setText(1, (const char*) (*nfo->version()) );
    // Version Major
    item = item->firstChild();
    // Fixme: name clash between kore::Module::Version::major() and stl::major(...)
    //item->setText(1, QString::number(nfo->version()->major()) );
    item->setText(1, "?" );
    // Version Minor
    item = item->nextSibling();
    // Fixme: name clash between kore::Module::Version::minor() and stl::minor(...)
    //item->setText(1, QString::number(nfo->version()->minor()) );
    item->setText(1, "?" );
    // Version Revision
    item = item->nextSibling();
    item->setText(1, QString::number(nfo->version()->revision()) );
    // API Version
    item = item->parent()->nextSibling();
    item->setText(1, (const char*) (*nfo->APIVersion()) );
    // API Major
    item = item->firstChild();
    // Fixme: name clash between kore::Module::Version::major() and stl::major(...)
    //item->setText(1, QString::number(nfo->APIVersion()->major()) );
    item->setText(1, "?" );
    // API Minor
    item = item->nextSibling();
    // Fixme: name clash between kore::Module::Version::minor() and stl::minor(...)
    //item->setText(1, QString::number(nfo->APIVersion()->minor()) );
    item->setText(1, "?" );
    // API Revision
    item = item->nextSibling();
    item->setText(1, QString::number(nfo->APIVersion()->revision()) );
    // Description
    item = item->parent()->nextSibling();
    item->setText(1, nfo->description() );

    _mvVersion = new Version(MV_MAJOR,MV_MINOR,MV_REVISION,MV_VERSION);
    _mvAPIVersion = new Version(MV_API_MAJOR,MV_API_MINOR,MV_API_REVISION,MV_API_VERSION);
    QString str(MV_NAME);
    // "Module View <My Module>"
    str = str+" <"+nfo->name()+">";
    _mvName = new char[str.length()+1];
    strcpy(_mvName, str);
    _mvInfo = new Info(this, _mvName, MV_TYPE, MV_DESCRIPTION, _mvVersion, _mvAPIVersion);
    setInfo(_mvInfo);
    _mvService = new Service(this, MV_SERVICE, MV_SERVICE_DESCRIPTION);
    addService(_mvService);
    str = MV_SERVICE "/";
    // "Kore/UI/ModuleView/<My Module>"
    str = str+"<"+nfo->name()+">";
    _mvsName = new char[str.length()+1];
    strcpy(_mvsName, str);
    _smvService = new Service(this, _mvsName , MV_SERVICE_DESCRIPTION);
    addService(_smvService);
}

/*
 *  Destroys the object and frees any allocated resources
 */
ModuleViewImpl::~ModuleViewImpl()
{
    // no need to delete child widgets, Qt does it all for us
    //qDebug("~ModuleViewImpl()\n");
    delete _mvInfo;
    delete _mvVersion;
    delete _mvAPIVersion;
    delete _mvService;
    delete[] _mvName;
    delete[] _mvsName;
}
