/*******************************************************************************
**                             helper.h
**                             part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/
#ifndef HELPER_H
#define HELPER_H

#include <kurl.h>

////////////////////////////////////////////////////////////////////////////////
///////                  class Helper                                    ///////
////////////////////////////////////////////////////////////////////////////////

class Helper
{
public:
    // Those are the modes for mode in isOK
    static const unsigned int CHECK_NOTHING    = 1;
    static const unsigned int CHECK_MALFORMED  = 2;
    static const unsigned int CHECK_LOCAL_FILE = 4;
    static const unsigned int CHECK_EMPTY      = 8;

    static QString homeDir();
    static bool isOK( KURL url, unsigned int mode = CHECK_NOTHING );
    static QString userGroup();
    static QString userName();
};

#endif
