/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   the_docter@gmx.net                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kommandoview.h"

KommandoView::KommandoView(QWidget* parent, const QString& name)
    : QListView(parent)
{
    if(name == QString::null){
        m_AppName = "default";
    } else {
        m_AppName = name;
    }
    setSorting(-1);
    addColumn("Menu");
    addColumn("Command");
}



KommandoViewList::KommandoViewList(bool autoDelete)
    : QPtrList<KommandoView>()
{
    setAutoDelete(autoDelete);
}

bool KommandoViewList::contains(const QString& view )
{
    return getView(view) != 0;
}

KommandoView * KommandoViewList::getView(const QString& view )
{
    for(KommandoView* it = first(); it != 0; it = next()){
        if(it->appName() == view){
            return it;
        }
    }
    return 0;
}

KommandoView * KommandoViewList::getViewOrDefault( const QString& view )
{
    KommandoView* temp = 0;
    for(KommandoView* it = first(); it != 0; it = next()){
        if(it->appName() == view){
            return it;
        }
        if((it->appName() == "default") || (it->appName() == QString::null)){
            temp=it;
        }
    }
    return temp;
}

void KommandoViewList::removeView( const QString & view )
{
    for(KommandoView* it = first(); it != 0; it = next()){
        if(it->appName() == view){
            remove();
            return;
        }
    }
}
