/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "sharedfolder_description.h"
#include "sharedfolder_listingmodel.h"
#include "sharedfolder_policy.h"
#include "sharedfolder_record.h"

#include "sharedfolder_page.h"

SharedFolderPage::SharedFolderPage()
  : mModel( 0 ), mDescription( 0 ),
    mPolicy( 0 ), mRecord( 0 )
{
}

SharedFolderPage::~SharedFolderPage()
{
  delete mModel;
  mModel = 0;

  delete mDescription;
  mDescription = 0;

  delete mPolicy;
  mPolicy = 0;

  delete mRecord;
  mRecord = 0;
}

QString SharedFolderPage::name() const
{
  return "sharedfolder";
}

QString SharedFolderPage::title() const
{
  return QObject::tr( "Shared Folder" );
}

QString SharedFolderPage::description() const
{
  return QObject::tr( "Manage shared folders" );
}

QString SharedFolderPage::iconName() const
{
  return "sharedfolder";
}

ListingModel* SharedFolderPage::model()
{
  if ( !mModel )
    mModel = new SharedFolderListingModel;

  return mModel;
}

Form::Description* SharedFolderPage::formDescription()
{
  if ( !mDescription )
    mDescription = new Form::SharedFolderDescription;

  return mDescription;
}

Form::PagePolicy* SharedFolderPage::formPolicy()
{
  if ( !mPolicy )
    mPolicy = new Form::SharedFolderPolicy;

  return mPolicy;
}

Form::Record* SharedFolderPage::formRecord()
{
  if ( !mRecord )
    mRecord = new Form::SharedFolderRecord;

  return mRecord;
}
