/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <QLabel>
#include <QLineEdit>
#include <QSpinBox>

#include "smtphostfield.h"

using namespace Form;

SmtpHostField::SmtpHostField( const QString &name, QWidget *parent )
  : Field( name, parent )
{
  mHost = new QLineEdit( this );

  QLabel *label = new QLabel( tr( "   Port: " ), this );

  mPort = new QSpinBox( this );
  mPort->setRange( 1, 65536 );
  mPort->setValue( 25 );

  fieldLayout()->addWidget( mHost, 0, 0 );
  fieldLayout()->addWidget( label, 0, 1, Qt::AlignRight );
  fieldLayout()->addWidget( mPort, 0, 2 );
}

void SmtpHostField::loadEntry( const Entry &entry )
{
  mHost->setText( entry.value( "postfix-relayhost" ) );

  if ( !entry.value( "postfix-relayport" ).isEmpty() )
    mPort->setValue( entry.value( "postfix-relayport" ).toInt() );
}

void SmtpHostField::saveEntry( Entry &entry ) const
{
  entry.setValue( "postfix-relayhost", mHost->text() );
  entry.setValue( "postfix-relayport", QString::number( mPort->value() ) );
}

bool SmtpHostField::isValid( QString&, PagePolicy::State ) const
{
  return true;
}

void SmtpHostField::setEditable( bool editable )
{
  mHost->setReadOnly( !editable );
  mPort->setEnabled( editable );
}

