/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <QGridLayout>
#include <QPushButton>

#include "dialog.h"
#include "pagepolicy.h"

#include "filtermodel.h"
#include "filterwidget.h"
#include "listingwidget.h"
#include "listingmodel.h"

#include "listingdialog.h"

ListingDialog::ListingDialog( Page *page, QWidget *parent )
  : QDialog( parent ), mPage( page )
{
  setWindowTitle( page->title() );

  mModel = page->model();

  QGridLayout *layout = new QGridLayout( this );

  FilterModel *filterModel = mModel->filterModel();
  if ( filterModel ) {
    FilterWidget *filterWidget = new FilterWidget( filterModel, this );
    layout->addWidget( filterWidget, 0, 0, 1, 3 );

    connect( filterWidget, SIGNAL( filter( const QString& ) ), mModel, SLOT( query( const QString& ) ) );
  }

  ListingWidget *widget = new ListingWidget( this );
  layout->addWidget( widget, 1, 0, 1, 3 );

  connect( widget, SIGNAL( addEntry() ), this, SLOT( addEntry() ) );
  connect( widget, SIGNAL( modifyEntry( const QString& ) ), this, SLOT( modifyEntry( const QString& ) ) );
  connect( widget, SIGNAL( deleteEntry( const QString& ) ), this, SLOT( deleteEntry( const QString& ) ) );

  QPushButton *button = new QPushButton( tr( "&Close" ), this );
  connect( button, SIGNAL( clicked() ), this, SLOT( accept() ) );
  layout->addWidget( button, 2, 2 );

  widget->setModel( mModel );

  mModel->query();

  resize( 800, 500 );
}

void ListingDialog::addEntry()
{
  Form::Dialog dlg( mPage, QString(), Form::PagePolicy::Add, this );
  if ( dlg.exec() )
    mModel->query();
}

void ListingDialog::modifyEntry( const QString &id )
{
  Form::Dialog dlg( mPage, id, Form::PagePolicy::Modify, this );
  if ( dlg.exec() )
    mModel->query();
}

void ListingDialog::deleteEntry( const QString &id )
{
  Form::Dialog dlg( mPage, id, Form::PagePolicy::Delete, this );
  if ( dlg.exec() )
    mModel->query();
}
