/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <QComboBox>
#include <QGridLayout>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>

#include "filtermodel.h"
#include "tool.h"

#include "filterwidget.h"

FilterWidget::FilterWidget( FilterModel *model, QWidget *parent )
  : QWidget( parent ), mModel( model )
{
  QGridLayout *layout = new QGridLayout( this );

  mAttribute = new QComboBox( this );
  mCriterion = new QComboBox( this );
  mUserInput = new QLineEdit( this );

  QPushButton *button = new QPushButton( tr( "&Filter" ), this );
  connect( button, SIGNAL( clicked() ), this, SLOT( executeUserFilter() ) );

  QLabel *label = new QLabel( tr( "Fi&lter:" ), this );
  label->setBuddy( mAttribute );
  layout->addWidget( label, 0, 0 );
  layout->addWidget( mAttribute, 0, 1 );
  layout->addWidget( mCriterion, 0, 2 );
  layout->addWidget( mUserInput, 0, 3 );
  layout->addWidget( button, 0, 4 );

  for ( int i = 0; i < mModel->rowCount(); ++i )
    mAttribute->addItem( mModel->data( mModel->index( i, 0 ) ).toString() );

  mCriterion->addItem( tr( "contains" ) );
  mCriterion->addItem( tr( "is" ) );
  mCriterion->addItem( tr( "begins with" ) );
  mCriterion->addItem( tr( "ends with" ) );
}

FilterWidget::~FilterWidget()
{
}

void FilterWidget::executeUserFilter()
{
  if ( mUserInput->text().isEmpty() ) {
    emit filter( QString() );
    return;
  }

  FilterModel::FilterCriterion criterion;
  switch ( mCriterion->currentIndex() ) {
    case 1:
      criterion = FilterModel::FilterEquals;
      break;
    case 2:
      criterion = FilterModel::FilterStartsWith;
      break;
    case 3:
      criterion = FilterModel::FilterEndsWith;
      break;
    case 0:
    default:
      criterion = FilterModel::FilterContains;
      break;
  }

  const QString userInput = Tool::escape( mUserInput->text() );

  emit filter( mModel->filter( mModel->index( mAttribute->currentIndex(), 0 ), userInput, criterion ) );
}

void FilterWidget::executeAlphaFilter()
{
}
