h29295
s 00001/00001/00226
d D 1.4 00/05/07 08:57:31 nitehawk 5 4
c IPV6 -> AFINDEP
cC
cK37699
cZ-07:00
e
s 00000/00000/00227
d D 1.3 00/03/07 11:48:09 nitehawk 4 3
cC
cK32226
e
s 00141/00000/00086
d D 1.2 00/03/03 20:14:38 nitehawk 3 2
c AF independant lookup complete
cC
cK37489
e
s 00086/00000/00000
d D 1.1 00/03/02 21:39:22 nitehawk 2 1
c BitKeeper file /usr/home/nitehawk/koalamud/src/idnsd/idnsd.c
cF1
cK38760
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/03/02 21:39:22 nitehawk 1 0
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK38146
cPsrc/idnsd/idnsd.c
cRebfb234685920e93
cV3
cX0xa1
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: IDNSD
\***************************************************************/

#define _KOALAMUD_MAIN_C "%Z% %K% %Z%"

I 3
/* This daemon reads an IP address on its stdin and writes the resolved name
 * to stdout.  It is expected that all input lines are either IP4 or IP6
 * addresses needing resolved.  If at some point there is a real need for name
 * to IP resolution, it will most likely be implemented in this subserver as
 * well.
 */

E 3
#include "autoconf.h"
#include "version.h"

I 3
/* Constants controlling operations */
/* Wait 5 seconds between retires */
#define IDNSD_RETRY_PAUSE	1

/* Maximum number of retries */
#define IDNSD_MAX_RETRIES	5

/* Length of a request line */
#define IDNSD_REQUEST_SIZE	512

E 3
char cvsstrings[][100] =
{
	_KOALAMUD_VERSION_H,
	_KOALAMUD_MAIN_C,
};

I 3
/* Display version string */
E 3
void displayversion(void)
{
	printf("%s", COPYRIGHTSTR);
}

I 3
/* Display help message */
E 3
void displayhelp(void)
{
	printf("%s", COPYRIGHTSTR);
	printf("Usage:\n");
	printf(
"-h             Show this screen\n"
"-V             Display version information\n"
);
}

I 3
/* Parse command line parameters */
E 3
int parseoptions(int argc, char *argv[])
{
	char opt = EOF;		// Current Option
	const char optionlist[] = "hV";	// Accepted Options

	opterr= 0;

	while ((opt = getopt(argc, argv, optionlist)) != -1)
	{
		switch (opt)
		{
		case 'h':  // User is requesting help
			displayhelp();
			exit(1);

		case 'V':
			displayversion();
			exit(1);

		case '?':
			printf("Bad option '%c' on command line.\n",
				optopt);
			displayhelp();
			exit(1);

		case ':':
			printf("Option '%c' missing argument.\n",
				optopt);
			displayhelp();
			exit(1);

		default:
			printf("Bad option '%c' on command line.\n",
				optopt);
			displayhelp();
			exit(1);
		}

	}

	return 0;
}

I 3
/* Lookup an reverse address */
D 5
#if IPV6
E 5
I 5
#if AFINDEP
E 5
/* AF Independant version */
static void lookup(char *inbuf)
{
	struct addrinfo *ai = NULL;
	int retries = 0;
	int err;
	char hostname[IDNSD_REQUEST_SIZE];

	/* Loop until we either reach our max retry count or successfully resolve
	 * the address */
	while ((err = getaddrinfo(inbuf, NULL, NULL, &ai)) != 0)
	{
		/* Print out an error reply on error */
		switch (err)
		{
		case EAI_ADDRFAMILY:
			printf("$error:  AF Problem resolving address\n");
			return;
		case EAI_FAIL:
			printf("$error:  Nonrecoverable resolution failure\n");
			return;
		case EAI_MEMORY:
			printf("$error:  Memory allocation failure\n");
			return;
		default:
			++retries;
		}

		if (retries >= IDNSD_MAX_RETRIES)
		{
			printf("$error:  Max retry count reached\n");
			return;
		}

		/* Give ourselves a moment to let the error possibly recover */
		sleep(IDNSD_RETRY_PAUSE);
	}

	/* Ok, we now have the information we need in an addrinfo struct, resolve
	 * it to the hostname with getnameinfo */
	while ((err = getnameinfo(ai->ai_addr, ai->ai_addrlen, hostname,
			IDNSD_REQUEST_SIZE, NULL, 0, 0)) != 0)
	{
		/* Print out an error reply on error */
		switch (err)
		{
		case EAI_ADDRFAMILY:
			printf("$error:  AF Problem resolving address\n");
			return;
		case EAI_FAIL:
			printf("$error:  Nonrecoverable resolution failure\n");
			return;
		case EAI_MEMORY:
			printf("$error:  Memory allocation failure\n");
			return;
		default:
			++retries;
		}

		if (retries >= IDNSD_MAX_RETRIES)
		{
			printf("$error:  Max retry count reached\n");
			return;
		}

		/* Give ourselves a moment to let the error possibly recover */
		sleep(IDNSD_RETRY_PAUSE);
	}

	/* Print out reply message */
	printf("$name: %d %s\n", strlen(hostname), hostname);

	/* Free resolver response */
	freeaddrinfo(ai);
}
#else
/* AF_INET version */
static void lookup(char *inbuf)
{
}
#endif

E 3
int main(int argc, char *argv[])
{
	int err = 0;
I 3
	char rdbuf[IDNSD_REQUEST_SIZE];
	char *el;
E 3

	err = parseoptions(argc, argv);
I 3

	/* Loop until we run out of data */
	for (;;)
	{
		/* Clear out buffer */
		memset(rdbuf, '\0', IDNSD_REQUEST_SIZE);
		
		/* Read a request line */
		if (fgets(rdbuf, IDNSD_REQUEST_SIZE, stdin) == NULL)
			exit(2);

		if ((el = strrchr(rdbuf, '\n')) == NULL)
			continue;   // Ignore incomplete lines
		*el = '\0';		// Strip the \n character
		if ((el = strrchr(rdbuf, '\r')) != NULL)
			*el = '\0';	// strip \r character

		/* Check for special commands before calling for a lookup */
		if (strcmp(rdbuf, "$hello") == 0)
		{
			printf("$alive\n");
			fflush(stdout);
			continue;
		}
		if (strcmp(rdbuf, "$shutdown") == 0)
		{
			exit(0);
		}

		/* resolve the address */
		lookup(rdbuf);

		/* Flush stdout */
		fflush(stdout);
	}
E 3

	return err;
}
E 2
I 1
E 1
